%* lsaf_userexists                                                                               *;
%*                                                                                               *;
%* Indicates whether a user account exists.                                                      *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.3                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2013-10-30 initial coding                                                                     *;
%* 2016-08-26  rebrand as LSAF                                                                   *;
%* 2020-12-04  updates for service refactor                                                      *;
%* 2021-08-18  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_userexists(
  lsaf_userid=
  ) /des='Is the user defined in the system.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafUserExists_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/user/UserService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("exists", "%bquote(&lsaf_userid)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine the existence of user '&lsaf_userid.'.";
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) then
      do;
        logMsg=" The user &lsaf_userid. was found.";
      end;
      else
      do;
        logMsg=" The user &lsaf_userid. was not found.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " _lsafUserExists_= " exists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafUserExists_", exists) ;

  run;

%mend lsaf_userexists ;
