%* lsaf_uploadandexpandinworkspace                                                                  *;
%*                                                                                                  *;
%* Uploads and expands the contents of a ZIP file into the specified folder location in the SAS     *;
%* Life Science Analytics Framework workspace.                                                      *;
%*                                                                                                  *;
%* macrotype LSAF                                                                                   *;
%* since 2.6                                                                                        *;
%* exposure external                                                                                *;
%*                                                                                                  *;
%* History                                                                                          *;
%* 2021-11-05  initial programming                                                                  *;
%*                                                                                                  *;

%macro lsaf_uploadandexpandinworkspace(
  local_path=,
  lsaf_path=
  ) /des='Uploads and expands a zip file into the SAS Life Science Analytics Framework workspace.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           rowCount        length=8

           sasLogFlag      length=$200
           sasLogAction    length=$200
           detailPath      length=$2048
    ;

    rowCount=0;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/workspace/BatchWorkspaceService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/SasActionStatusResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("uploadAndExpand", "%bquote(&local_path)", "%bquote(&lsaf_path)", results) ;

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);
    results.callIntMethod("getSize", rowCount);

    %***********************************;
    %* Print messages in log           *;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Could not attempt the operation to upload and expand the file to target workspace path: &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Attempted the operation to upload and expand the file to target workspace path: &lsaf_path.." ;
    end;

    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_ = " returnCode ;

    if (rowCount > 0) then
    do;
       macroNameStamp=strip(lowcase("&SYSMACRONAME")) || ": ";
       do row=0 to rowCount - 1;
         results.callStringMethod("getDetailPath", row, detailPath);
         results.callStringMethod("getDetailStatus", row, sasLogFlag);
         results.callStringMethod("getDetailMessage", row, sasLogAction);
         sasLogFlag   = strip(sasLogFlag)   || ": ";
         sasLogAction = strip(sasLogAction) || ": ";
         put sasLogFlag macroNameStamp sasLogAction detailPath;
       end;
    end;
    put "-" ;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_uploadandexpandinworkspace;
