%* lsaf_updateworkspacejob                                                                           *;
%*                                                                                                   *;
%* Updates a job in workspace of the current user.                                                   *;
%*                                                                                                   *;
%* macrotype LSAF                                                                                    *;
%* since 1.5                                                                                         *;
%* exposure external                                                                                 *;
%*                                                                                                   *;
%* History                                                                                           *;
%* 2016-09-23  initial coding                                                                        *;
%* 2019-02-11  update to 2.1                                                                         *;
%* 2020-08-11  update parameters and column names to reflect LSAF 5.3 compatibility.                 *;
%* 2021-04-07  update for java code refactor                                                         *;
%* 2021-08-06  Remove header documentation                                                           *;
%* 2023-03-09  DE17654 - SAS Notes option updates                                                    *;
%*                                                                                                   *;

%macro lsaf_updateworkspacejob(
   lsaf_path=,
   sas_dsname_info=%str(_lsaf_updateworkspacejob_ds_notprovided_),
   sas_dsname_programs=%str(_lsaf_updateworkspacejob_ds_notprovided_),
   sas_dsname_parameters=%str(_lsaf_updateworkspacejob_ds_notprovided_),
   sas_dsname_setup=%str(_lsaf_updateworkspacejob_ds_notprovided_),
   sas_dsname_checkin=%str(_lsaf_updateworkspacejob_ds_notprovided_)
   ) /des='Update a job in the workspace.';

   %****************************************;
   %* Initialize macro variables           *;
   %****************************************;
   %lsaf_getProductName();

   %global _lsafMsg_
           _lsafRC_          
   ;

   %local haveData
          haveObs
          logMsgPrefix
          logMsgPrimary
          macroName
		  notesOption
   ;

   %let haveData =%str(1);
   %let _lsafRC_ =%str(-999);
   %let _lsafMsg_=%str(The SAS Macro did not execute properly. Unknown err%str(or).);
   %let _lsafWorkspaceJobPath_=;

   %let notesOption=%sysfunc(getoption(notes));

   %*********************************************************************************;
   %* Validate all input data sets and update master data set to set server values. *;
   %* Initializes _lsafMASTERJobDATA_tempDS_ input macro variable.                  *;
   %*********************************************************************************;
   %let macroName=%sysfunc(lowcase(&SYSMACRONAME));
   %lsaf_process_jobdatasets(callingMacro=&macroName,
                              sas_dsname_info=&sas_dsname_info,
                              sas_dsname_programs=&sas_dsname_programs,
                              sas_dsname_parameters=&sas_dsname_parameters,
                              sas_dsname_setup=&sas_dsname_setup,
                              sas_dsname_checkin=&sas_dsname_checkin
   );
   %let logMsgPrimary=%str(ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro: );
   %let logMsgPrefix=%str(NOTE: &_LSAF_PRODUCT_NAME_ Macro: );

   options &notesOption.;

   %if (&_lsafRC_ ne 0) %then
   %do;
     %GOTO PRINT_DSERROR_LOG_MSGS;
   %end;

   %if (&_lsafMASTERJobDATA_tempDS_ EQ %str(_null_)) %then
   %do;
     %LET haveData=0;
   %end;

   %LET haveObs=0;

   %let _lsafMASTERJobDATA_ID_ = %sysfunc( open(&_lsafMASTERJobDATA_tempDS_) );
   %let _lsafMASTERJobDATA_NOBS_ = %sysfunc( attrn(&_lsafMASTERJobDATA_ID_,nobs) );
   %let _lsafMASTERJobDATA_RC_ = %sysfunc( close(&_lsafMASTERJobDATA_ID_) );

   %if (&_lsafMASTERJobDATA_NOBS_ GE 1) %then
   %do;
     %LET haveObs=1;
   %end;

   %let _lsafRC_ =%str(-999);

   %**********************************************;
   %* Process the records                        *;
   %**********************************************;
   data _null_;
      attrib returnCode      length=8
             message         length=$200
             logMsgPrefix    length=$70
             logMsgPrimary   length=$70
             logMsg          length=$300
      ;

      %if (&haveObs EQ 1) %then
      %do;
        set &_lsafMASTERJobDATA_tempDS_ end=eof;
        if (_n_ EQ 1) then
        do;
      %end;
         %***********************************;
         %* Declare the java objects, once  *;
         %***********************************;
         declare javaobj srv("com/sas/lsaf/macro/execution/job/JobService");
         declare javaobj results("com/sas/lsaf/macro/common/result/Result");
         declare javaobj info("com/sas/lsaf/macro/execution/job/SasJobInfo");
         declare javaobj programs("com/sas/lsaf/macro/execution/job/SasJobPrograms");
         declare javaobj params("com/sas/lsaf/macro/execution/job/SasJobParameters");
         declare javaobj setup("com/sas/lsaf/macro/execution/job/SasJobPublishSetups");
         declare javaobj checkin("com/sas/lsaf/macro/execution/job/SasJobPublishCheckinLocations");

         %if (&haveData EQ 1) %then
         %do;
           setData="1";
           %if (&sas_dsname_programs NE %str(_lsaf_updateworkspacejob_ds_notprovided_)) %then
           %do;
             programs.callVoidMethod("setUpdateData", kstrip(setData));
           %end;
           %if (&sas_dsname_parameters NE %str(_lsaf_updateworkspacejob_ds_notprovided_)) %then
           %do;
             params.callVoidMethod("setUpdateData", kstrip(setData));
           %end;
           %if (&sas_dsname_setup NE %str(_lsaf_updateworkspacejob_ds_notprovided_)) %then
           %do;
             setup.callVoidMethod("setUpdateData", kstrip(setData));
           %end;
           %if (&sas_dsname_checkin NE %str(_lsaf_updateworkspacejob_ds_notprovided_)) %then
           %do;
             checkin.callVoidMethod("setUpdateData", kstrip(setData));
           %end;
         %end;

      %if (&haveObs EQ 1) %then
      %do;
        end;  * ends if (_n_=1);
        if (source EQ "&source_info") then
        do;
          name=kstrip(lowcase(name));
          select (name);
            when ("documentation") info.callVoidMethod("setDescription", kstrip(value));
            when ("logslocation") info.callVoidMethod("setLogsLocation", kstrip(value));
            when ("resultslocation") info.callVoidMethod("setResultsLocation", kstrip(value));
            when ("manifestlocation") info.callVoidMethod("setManifestLocation", kstrip(value));
            when ("newoutputs_customversion") info.callVoidMethod("setCustomVersion", kstrip(value));
            when ("newoutputs_enableversion") info.callVoidMethod("setEnableVersioning", kstrip(value));
            when ("newoutputs_versiontype") info.callVoidMethod("setVersionType", kstrip(upcase(value)));
            otherwise;
          end;
        end;
        else if (source EQ "&source_parms") then
        do;
          params.callVoidMethod("addValue", kstrip(name), kstrip(pLabel), kstrip(type), kstrip(value), kstrip(version), includeSubFolders);
        end;
        else if (source EQ "&source_programs") then
        do;
          programs.callVoidMethod("addItem", kstrip(value), kstrip(version));
        end;
        else if (source EQ "&source_setup") then
        do;
          setup.callVoidMethod("addItem", kstrip(value), kstrip(type), kstrip(version), includeSubFolders, includeFiles);
        end;
        else if (source EQ "&source_checkin") then
        do;
          checkin.callVoidMethod("addItem", kstrip(value), includeSubFolders);
        end;

        %***********************************;
        %* Attempt the operation           *;
        %***********************************;
        if (eof);
      %end;

      srv.callStaticVoidMethod("updateWorkspaceJob", "%bquote(&lsaf_path)", info, programs, params, setup, checkin, results);

      %***********************************;
      %* Retrieve the results            *;
      %***********************************;
      results.callIntMethod("getReturnCode", returnCode);
      results.callStringMethod("getReturnMessage", message);

      %***********************************;
      %* Process the results             *;
      %***********************************;
      logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
      if (returnCode ne 0) 
      then
      do;
        logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
        logMsg=" Could not update job in the workspace: &lsaf_path.";
      end;
      else
      do;
        logMsgPrimary=logMsgPrefix;
        logMsg=" Updated job in workspace using path &lsaf_path.";
      end;

      %***********************************;
      %* Print messages in log           *;
      %***********************************;
      put;
      put logMsgPrimary " " logMsg;
      put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
      put logMsgPrefix " _lsafMsg_= " message;
      put logMsgPrefix " _lsafRC_= " returnCode;

      %if (&haveData NE 1) %then
      %do;
        put logMsgPrefix " No job data was provided.";
      %end;
      %else
      %do;
        %if (&sas_dsname_info NE _lsaf_updateworkspacejob_ds_notprovided_) %then
        %do;
          put logMsgPrefix " sas_dsname_info = &sas_dsname_info";
        %end;
        %if (&sas_dsname_programs NE _lsaf_updateworkspacejob_ds_notprovided_) %then
        %do;
          put logMsgPrefix " sas_dsname_programs = &sas_dsname_programs";
        %end;
        %if (&sas_dsname_parameters NE _lsaf_updateworkspacejob_ds_notprovided_) %then
        %do;
          put logMsgPrefix " sas_dsname_parameters = &sas_dsname_parameters";
        %end;
        %if (&sas_dsname_setup NE _lsaf_updateworkspacejob_ds_notprovided_) %then
        %do;
          put logMsgPrefix " sas_dsname_setup = &sas_dsname_setup";
        %end;
        %if (&sas_dsname_checkin NE _lsaf_updateworkspacejob_ds_notprovided_) %then
        %do;
          put logMsgPrefix " sas_dsname_checkin = &sas_dsname_checkin";
        %end;
      %end;

      %***********************************;
      %* Set the macro variables         *;
      %***********************************;
      call symputx("_lsafRC_", returnCode);
      call symputx("_lsafMsg_", message);

   run;

   %if (%sysfunc(exist(&_lsafMASTERJobDATA_tempDS_)) > 0) %then
   %do;
     options nonotes;
     proc datasets library=work nolist;
        delete &_lsafMASTERJobDATA_tempDS_;
     quit;
     run;
	 options &notesOption.;
   %end;

   %return;

   %PRINT_DSERROR_LOG_MSGS:
      options nonotes;
      %put &logMsgPrimary  &macroName ;
      %put &logMsgPrefix _lsafRC_= &_lsafRC_ ;
      %put &logMsgPrefix _lsafMsg_= &_lsafMsg_ ;
      %put;

   options &notesOption.;

%mend lsaf_updateworkspacejob;
