%* lsaf_updateworkspacefile                                                                             *;
%*                                                                                                      *;
%* Updates the contents of a file in the workspace.                                                     *;
%*                                                                                                      *;
%* macrotype LSAF                                                                                       *;
%* since 2.6                                                                                            *;
%* exposure external                                                                                    *;
%*                                                                                                      *;
%* History                                                                                              *;
%* 2021-11-10  initial coding                                                                           *;
%* 2016-08-26  rebrand as LSAF                                                                          *;
%*                                                                                                      *;

%macro lsaf_updateworkspacefile(
  local_path=,
  lsaf_path=,
  ) /des='Update the contents of an existing SAS Life Science Analytics Framework workspace file.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/workspace/WorkspaceService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("updateFile", "%bquote(&local_path)", "%bquote(&lsaf_path)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The workspace file was updated: &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot update workspace file: &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " local_path= &local_path" ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_updateworkspacefile ;
