%* lsaf_updateversionlimits                                                                        *;
%*                                                                                                 *;
%* Sets the version limits on files and default version limits on containers.                      *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 2.4                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2020-09-04  initial coding                                                                      *;
%* 2021-08-13  Remove header documentation                                                         *;
%*                                                                                                 *;
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_updateversionlimits(                                                                                                                                                                                                                                                                                                      
  lsaf_path=,                                                                                                                                                                                                                                                                                                                        
  lsaf_versionmajor=_LSAF_VALUE_NOT_PROVIDED_,                                                                                                                                                                                                                                                                                                                       
  lsaf_versionminor=_LSAF_VALUE_NOT_PROVIDED_                                                                                                                                                                                                                                                                                                          
  ) /des='Update the version limit of a file or set the default version of a container object.';                                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getProductName();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_                                                                                                                                                                                                                                                                                                                  
          _lsafRC_                                                                                                                                                                                                                                                                                                                   
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_=%str(-999);                                                                                                                                                                                                                                                                                                          
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode      length=8;                                                                                                                                                                                                                                                                                                 
    attrib message         length=$200;                                                                                                                                                                                                                                                                                              
    attrib logMsgPrefix    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrimary   length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg          length=$300;                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");                                                                                                                                                                                                                                                                 
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("updateVersionLimits", "%bquote(&lsaf_path)", "%bquote(&lsaf_versionmajor)", "%bquote(&lsaf_versionminor)", results);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The version limits for the repository object &lsaf_path were updated." ;
    
    if (returnCode ne 0) then                                                                                                                                                                                                                                                                                                        
    do;                                                                                                                                                                                                                                                                                                                              
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";                                                                                                                                                                                                                                                                       
      logMsg=" Cannot update version limits for repository object &lsaf_path." ;                                                                                                                                                                                                                                                                                  
    end;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message ;                                                                                                                                                                                                                                                                                        
    put logMsgPrefix " _lsafRC_= " returnCode ;                                                                                                                                                                                                                                                                                      
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_updateversionlimits;                                                                                                                                                                                                                                                                                                       
