%* lsaf_updatepfusertaskcandidates                                                     *;
%*                                                                                     *;
%* Updates the process flow user task candidates using a data set as input.            *;
%*                                                                                     *;
%* macrotype LSAF                                                                      *;
%* since 2.5                                                                           *;
%* exposure external                                                                   *;
%*                                                                                     *;
%* History                                                                             *;
%* 2021-02-26  original coding                                                         *;
%* 2021-08-12  Remove header documentation                                             *;
%* 2021-10-21  principal refactor                                                      *;
%* 2023-03-09  DE17654 - SAS Notes option updates                                      *;
%*                                                                                     *;

%macro lsaf_updatepfusertaskcandidates(
  lsaf_taskid=,
  sas_dsname=
  ) /des='Update the process flow user task candidates.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %local logMsgPrefix
         logMsgPrimary
         macroName
		 notesOption
         RC
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);
  %let macroName=%sysfunc(lowcase(&SYSMACRONAME));

  %***************************************************************************;
  %* Set local macro variables for processing.                               *;
  %***************************************************************************;
  %let logMsgPrimary=%str(ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro: );
  %let logMsgPrefix=%str(NOTE: &_LSAF_PRODUCT_NAME_ Macro: );

  %*************************************************************;
  %* Turn off the notes generated for all the pre-processing.  *;
  %* Save original option setting so it can be reset properly. *;
  %*************************************************************;
  %let notesOption=%sysfunc(getoption(notes));
  options nonotes;

  %***************************************************************************;
  %* Validate the input data set                                             *;
  %* sets global macro variable _lsafRC_=0 if validation successful          *;
  %***************************************************************************;
  %lsaf_validate_sasdataset(callingMacro=&macroName,
        sas_dsn=&sas_dsname,
        required_variables=%str(candidateType candidateId  grpSrcCtxt)
        );

  options &notesOption.;
  %if (&_lsafRC_ ne 0) %then
  %do;
    %put &logMsgPrimary _lsafMsg_= &_lsafMsg_ ;
    %put &logMsgPrefix &macroName ;
    %put &logMsgPrefix Input data set = &sas_dsname;
    %put &logMsgPrefix _lsafRC_= &_lsafRC_ ;
    %put;
    %return;
  %end;

  %***************************************************************************;
  %* If data set is valid, process it.                                       *;
  %***************************************************************************;
  %put NOTE: &macroName: Processing data set &sas_dsname;

  %**********************************************;
  %* Process the records                        *;
  %**********************************************;
  data _null_;
    attrib returnCode    length=8
           message       length=$200
    ;
    set &sas_dsname end=eof;

    %***********************************;
    %* Declare the java objects, once  *;
    %***********************************;
    if (_n_ = 1) then
    do;
      declare javaobj candidates("com/sas/lsaf/macro/security/SasPrincipalDescriptors");
      declare javaobj srv("com/sas/lsaf/macro/workflow/task/ProcessFlowTaskService");
      declare javaobj results("com/sas/lsaf/macro/common/result/Result");
    end;

    %**********************************;
    %* Create a new candidates list   *;
    %**********************************;
    candidates.callVoidMethod("addValue", kstrip(candidateType), kstrip(candidateId), kstrip(grpSrcCtxt));

    if eof then
    do;
      %***********************************;
      %* Call the update                 *;
      %***********************************;
      srv.callStaticVoidMethod("updateUserTaskCandidates", "%bquote(&lsaf_taskId)", candidates, results);

      %***********************************;
      %* Retrieve the results            *;
      %***********************************;
      results.callIntMethod("getReturnCode", returnCode);
      results.callStringMethod("getReturnMessage", message);

      %***********************************;
      %* Process the results             *;
      %***********************************;
      logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
      logMsgPrimary=logMsgPrefix;
      logMsg=" Update process flow user task candidates ran successfully for task &lsaf_taskid.." ;
      if (returnCode ne 0) then
      do;
        logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
        logMsg=" Cannot update process flow user task candidates for task &lsaf_taskid.." ;
      end;

      %***********************************;
      %* Print messages in log           *;
      %***********************************;
      put;
      put logMsgPrimary " " logMsg;
      put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
      put logMsgPrefix " Input data set = &sas_dsname";
      put logMsgPrefix " _lsafMsg_= " message ;
      put logMsgPrefix " _lsafRC_= " returnCode ;
      put;

      %***********************************;
      %* Set the macro variables         *;
      %***********************************;
      call symputx("_lsafRC_", returnCode);
      call symputx("_lsafMsg_", message);
    end;
  run;

%mend lsaf_updatepfusertaskcandidates;
