%* lsaf_updatefile                                                                                      *;
%*                                                                                                      *;
%* Updates the contents of a file in the repository.                                                    *;
%*                                                                                                      *;
%* macrotype LSAF                                                                                       *;
%* since 1.1                                                                                            *;
%* exposure external                                                                                    *;
%*                                                                                                      *;
%* History                                                                                              *;
%* 2013-08-30  updates for standardization and coding conventions                                       *;
%* 2016-08-26  rebrand as LSAF                                                                          *;
%* 2018-01-09  updates to documentation for LSAF 5.1                                                    *;
%* 2019-02-19  update to 2.1                                                                            *;
%* 2019-10-30  update to allow custom version                                                           *;
%* 2020-11-18  updated for version handling.                                                            *;
%* 2021-08-13  Remove header documentation                                                              *;
%*                                                                                                      *;

%macro lsaf_updatefile(
  local_path=,
  lsaf_path=,
  lsaf_comment=,
  lsaf_versiontype=,
  lsaf_customversion=
  ) /des='Update the contents of an existing SAS Life Science Analytics Framework item.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
	declare javaobj checkin("com/sas/lsaf/macro/content/repository/SasFileCheckinParameters");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
	checkin.callVoidMethod("setData","","%bquote(&lsaf_versiontype)","%bquote(&lsaf_customversion)","%bquote(&lsaf_comment)");

    srv.callStaticVoidMethod("updateFile", "%bquote(&local_path)", "%bquote(&lsaf_path)", checkin, results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The file was updated: &lsaf_path.." ;
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot update file: &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " local_path= &local_path" ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_updatefile ;
