%* lsaf_updatedefinitionmappings                                                                 *;
%*                                                                                               *;
%* Updates the process definition mappings.                                                      *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.5                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2021-05-26  initial programming                                                               *;
%* 2021-07-13  updated for new service name                                                      *;
%* 2021-08-10  Remove header documentation                                                       *;
%* 2023-03-09  DE17654 - SAS Notes option updates                                                *;
%*                                                                                               *;

%macro lsaf_updatedefinitionmappings(
   lsaf_processdefid=,
   lsaf_autoflowtype=,
   sas_dsname=_lsaf_updatepf_donotupdate_
   ) /des='Updates the process ddefinition autoflow mappings.';

   %****************************************;
   %* Initialize macro variables           *;
   %****************************************;
   %lsaf_getProductName();

   %global _lsafMsg_
           _lsafRC_
   ;

   %local logMsgPrefix
          logMsgPrimary
          macroName
		  notesOption
   ;

   %let _lsafRC_ =%str(-999);
   %let _lsafMsg_=%str(The SAS Macro did not execute properly. Unknown err%str(or).);
   %let logMsgPrimary=%str(ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro: );
   %let logMsgPrefix=%str(NOTE: &_LSAF_PRODUCT_NAME_ Macro: );
   %let macroName=%sysfunc(lowcase(&SYSMACRONAME));

   %*************************************************************;
   %* Save original option setting so it can be reset properly. *;
   %*************************************************************;
   %let notesOption=%sysfunc(getoption(notes));

   %if (&sas_dsname=_lsaf_updatepf_donotupdate_) %then
   %do;
     %let _lsafMsg_= %str(No data has been provided for the update.);
     %GOTO PRINT_DSERROR_LOG_MSGS;
   %end;

   %if ( %CMPRES(&sas_dsname) NE %str(_lsaf_updatepf_donotupdate_) ) %then
   %do;
     %***************************************************************************;
     %* Validate the Process Flow Data data set if supplied.                    *;
     %* sets global macro variable _lsafRC_=0 if validation successful          *;
     %***************************************************************************;
     %lsaf_validate_sasdataset(callingMacro=&macroName,
                               sas_dsn=&sas_dsname,
                               required_variables=%str(elementId elementAttrName mappingName),
                               allow_empty_datasets=0);
   option &notesOption.;
   %if (&_lsafRC_ ne 0) %then
     %do;
       %let _lsafMsg_= sas_dsname: &_lsafMsg_;
       %GOTO PRINT_DSERROR_LOG_MSGS;
     %end;
   %end;

   %**********************************************;
   %* Process the records                        *;
   %**********************************************;
   data _null_;
      attrib returnCode      length=8
              message        length=$200
              logMsgPrefix   length=$70
              logMsgPrimary  length=$70
              logMsg         length=$300
      ;

      set &sas_dsname end=eof;
      if (_n_ EQ 1) then
      do;
        %***********************************;
        %* Declare the java objects        *;
        %***********************************;
        declare javaobj srv("com/sas/lsaf/macro/workflow/definition/mapping/ProcessDefinitionMappingService");
        declare javaobj results("com/sas/lsaf/macro/common/result/Result");
        declare javaobj data("com/sas/lsaf/macro/workflow/definition/mapping/SasFlowElementMappings");
      end;

      data.callVoidMethod("addMapping", kstrip(elementId), kstrip(elementAttrName), kstrip(mappingName));

      if (eof);

      %***********************************;
      %* Attempt the operation           *;
      %***********************************;
      srv.callStaticVoidMethod("updateProcessDefinitionMappings", "%bquote(&lsaf_processdefid)", 
                               "%bquote(&lsaf_autoflowtype)", data, results);

      %***********************************;
      %* Retrieve the results            *;
      %***********************************;
      results.callIntMethod("getReturnCode", returnCode);
      results.callStringMethod("getReturnMessage", message);

      %***********************************;
      %* Process the results             *;
      %***********************************;
      logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
      if (returnCode ne 0) then
      do;
        logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
        logMsg=" Cannot update process definition autoflow mappings for &lsaf_processdefid.." ;
      end;
      else
      do;
        logMsgPrimary=logMsgPrefix;
        logMsg=" The process definition autoflow mappings were updated for &lsaf_processdefid.." ;
      end;

      %***********************************;
      %* Print messages in log           *;
      %***********************************;
      put;
      put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
      put logMsgPrimary " " logMsg;
      put logMsgPrefix " _lsafMsg_= " message ;
      put logMsgPrefix " _lsafRC_= " returnCode ;
      put;

      %***********************************;
      %* Set the macro variables         *;
      %***********************************;
      call symputx("_lsafRC_", returnCode);
      call symputx("_lsafMsg_", message);

   run;

   %return;

   %PRINT_DSERROR_LOG_MSGS:
      %put &logMsgPrimary _lsafMsg_= &_lsafMsg_ ;
      %put &logMsgPrefix  &macroName ;
      %put &logMsgPrefix _lsafRC_= &_lsafRC_ ;
      %put;

%mend lsaf_updatedefinitionmappings;
