%* lsaf_updatecontextstate                                                                         *;                                                                                                                                                                                                                                
%*                                                                                                 *;                                                                                                                                                                                                                                
%* Updates the state of a context in the repository.                                               *;
%*                                                                                                 *;                                                                                                                                                                                                                                
%* macrotype LSAF                                                                                  *;                                                                                                                                                                                                                                
%* since 2.1                                                                                       *;                                                                                                                                                                                                                                
%* exposure external                                                                               *;                                                                                                                                                                                                                                
%*                                                                                                 *;                                                                                                                                                                                                                                
%* History                                                                                         *;
%* 2019-01-29  initial coding                                                                      *;
%* 2021-08-13  Remove header documentation                                                         *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                 *;
%*                                                                                                 *;                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_updatecontextstate(                                                                                                                                                                                                                                                                                                      
  lsaf_path=,                                                                                                                                                                                                                                                                                                                        
  lsaf_state=,                                                                                                                                                                                                                                                                                                                       
  lsaf_comment=,                                                                                                                                                                                                                                                                                                                     
  lsaf_recursive=                                                                                                                                                                                                                                                                                                            
  ) /des='Update the state of a context.';                                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getProductName();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_                                                                                                                                                                                                                                                                                                                  
          _lsafRC_                                                                                                                                                                                                                                                                                                                   
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_=%str(-999);                                                                                                                                                                                                                                                                                                          
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode      length=8;                                                                                                                                                                                                                                                                                                 
    attrib message         length=$200;                                                                                                                                                                                                                                                                                              
    attrib logMsgPrefix    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrimary   length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg          length=$300;                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");                                                                                                                                                                                                                                                                 
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("setContextState", "%bquote(&lsaf_path)", "%bquote(&lsaf_state)", "%bquote(&lsaf_comment)",                                                                                                                                                                                                                 
              "%bquote(&lsaf_recursive)", results);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The state for context &lsaf_path was updated to &lsaf_state.." ;                                                                                                                                                                                                                                                                                  
    if (returnCode ne 0) then                                                                                                                                                                                                                                                                                                        
    do;                                                                                                                                                                                                                                                                                                                              
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";                                                                                                                                                                                                                                                                       
      logMsg=" Cannot update context &lsaf_path." ;                                                                                                                                                                                                                                                                                  
    end;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafMsg_= " message ;                                                                                                                                                                                                                                                                                        
    put logMsgPrefix " _lsafRC_= " returnCode ;                                                                                                                                                                                                                                                                                      
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_updatecontextstate;                                                                                                                                                                                                                                                                                                       
