%* lsaf_typehascapability                                                                              *;
%*                                                                                                     *;
%* Indicates whether the type has the specified capability in the repository.                          *;
%*                                                                                                     *;
%* macrotype LSAF                                                                                      *;
%* since 2.1                                                                                           *;
%* exposure external                                                                                   *;
%*                                                                                                     *;
%* History                                                                                             *;
%* 2019-03-04  initial coding                                                                          *;
%* 2020-07-13  update for refactor of java service hierarchy.                                          *;
%* 2021-08-17  Remove header documentation                                                             *;
%* 2021-09-07  Update for US11675 & US11678                                                            *;
%*                                                                                                     *;

%macro lsaf_typehascapability(
  lsaf_typeid=,
  lsaf_capability=
  ) /des='Does the type have the specified capability?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafTypeHasCapability_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode          length=8;
    attrib message             length=$200;
    attrib logMsgPrefix        length=$70;
    attrib logMsg              length=$300;
    attrib typeHasCapability   length=3;
    attrib logMsgPrimary       length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/core/type/TypeService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("typeHasCapability", "%bquote(&lsaf_typeid)", "%bquote(&lsaf_capability)", results, typeHasCapability);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the item &lsaf_typeid has capability &lsaf_capability.." ;
      typeHasCapability=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (typeHasCapability) 
        then logMsg=" The item &lsaf_typeid has capability: &lsaf_capability..";
        else logMsg=" The item &lsaf_typeid does not have capability: &lsaf_capability..";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafTypeHasCapability_= " typeHasCapability;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafTypeHasCapability_", typeHasCapability);

  run;

%mend lsaf_typehascapability;
