%* lsaf_typexists                                                                                *;
%*                                                                                               *;
%* Indicates whether a type exists.                                                              *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.3                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2020-01-17 initial coding                                                                     *;
%* 2020-07-13  update for refactor of java service hierarchy.                                    *;
%* 2021-08-17  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_typeexists(
  lsaf_typeid=
  ) /des='Is the type defined in the system?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafTypeExists_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/core/type/TypeService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("typeExists", "%bquote(&lsaf_typeid)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine the existence of type '&lsaf_typeid.'.";
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) then
      do;
        logMsg=" The type &lsaf_typeid. was found.";
      end;
      else
      do;
        logMsg=" The type &lsaf_typeid. was not found.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafTypeExists_", exists) ;

  run;

%mend lsaf_typeexists ;
