%* lsaf_suspendprocessdefinition                                                                         *;
%*                                                                                                       *;
%* Suspends a process flow definition. The PRIVILEGE_MANAGE_PROCESS_FLOW_DEFINITIONS global privilege    *;
%* is required.                                                                                          *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 2.2                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2019-09-12  Initial coding                                                                            *;
%* 2021-08-10  Remove header documentation                                                               *;
%*                                                                                                       *;

%macro lsaf_suspendprocessdefinition(
  lsaf_processdefid=
  ) /des='Suspend an active process flow definition.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/ProcessDefinitionService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("suspendProcessDefinition", "%bquote(&lsaf_processdefid)", results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot suspend process flow definition: &lsaf_processdefid..";
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The process flow definition: &lsaf_processdefid was suspended.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_suspendprocessdefinition;
