%* lsaf_submitworkspacejob                                                                           *;
%*                                                                                                   *;
%* Submits a workspace job for immediate execution.                                                  *;
%*                                                                                                   *;
%* macrotype LSAF                                                                                    *;
%* since 1.5                                                                                         *;
%* exposure external                                                                                 *;
%*                                                                                                   *;
%* History                                                                                           *;
%* 2016-10-20  initial coding                                                                        *;
%* 2019-02-11  update to 2.1                                                                         *;
%* 2020-06-30  update service location                                                               *;
%* 2021-08-09  Remove header documentation                                                           *;
%* 2021-09-28  Update for java refactoring                                                           *;
%* 2021-11-16  2.6: Added parameter RunAsTest                                                        *;
%* 2023-03-09  DE17654 - SAS Notes option updates                                                    *;
%*                                                                                                   *;

%macro lsaf_submitworkspacejob(
   lsaf_path=,
   lsaf_runAsTest=,
   sas_dsname=
   ) /des='Submits a workspace job for execution.';

   %****************************************;
   %* Initialize macro variables           *;
   %****************************************;
   %lsaf_getProductName();

   %global _lsafMsg_
           _lsafRC_
           _lsafWorkspaceJobSubmissionId_
   ; 
   %local logMsgPrefix
          logMsgPrimary
          macroName
          notesOption
          parametersProvided
          _tempRUNWSJOB_tempDS_
   ;

   %let _lsafWorkspaceJobSubmissionId_=;
   %let _lsafRC_ =%str(-999);
   %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

   %let macroName=%sysfunc(lowcase(&SYSMACRONAME));
   %let logMsgPrimary=%str(ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro: );
   %let logMsgPrefix=%str(NOTE: &_LSAF_PRODUCT_NAME_ Macro: );
   %let parametersProvided=0;

   %*************************************************************;
   %* Save original option setting so it can be reset properly. *;
   %*************************************************************;
   %let notesOption=%sysfunc(getoption(notes));

   %if ( %CMPRES(&sas_dsname) NE %str() ) %then
   %do;

      %***************************************************************************;
      %* Validate the parameters data set if supplied.                           *;
      %* sets global macro variable _lsafRC_=0 if validation successful          *;
      %***************************************************************************;
      %lsaf_validate_parameters_dataset(callingMacro=&macroName., sas_dsn=&sas_dsname.);
      %if (&_lsafRC_ ne 0) %then
      %do;
         %GOTO PRINT_DSERROR_LOG_MSGS;
      %end;

      %let parametersProvided=1;
   %end;

   option &notesOption.;

   %**********************************************;
   %* Process the records                        *;
   %**********************************************;
   data _null_;
      attrib returnCode      length=8
             message         length=$200
             jobSubmissionId length=$525
             logMsgPrefix    length=$70
             logMsgPrimary   length=$70
             logMsg          length=$300
      ;

      %if (&parametersProvided) %then
      %do;
         set &sas_dsname end=eof;
         if (_n_ = 1) then
         do;
      %end;

      %***********************************;
      %* Declare the java objects, once  *;
      %***********************************;
      declare javaobj params("com/sas/lsaf/macro/execution/job/SasParameterValues");
      declare javaobj srv("com/sas/lsaf/macro/execution/jobsubmission/JobSubmissionService");
      declare javaobj results("com/sas/lsaf/macro/common/result/Result");

      %if (&parametersProvided) %then
      %do;
         end;
         params.callVoidMethod("addValue", kstrip(name), kstrip(value), kstrip(type), kstrip(fileVersion), includeSubfolders);
         if (eof);
      %end;

      %***********************************;
      %* Submit the job                  *;
      %***********************************;
      declare javaobj job("com/sas/lsaf/macro/execution/jobsubmission/SasSubmittableJob", 
            "%bquote(&lsaf_path)", params);
      srv.callStaticStringMethod("submitWorkspaceJob", job, "%bquote(&lsaf_runAsTest)", results, jobSubmissionId);

      %***********************************;
      %* Retrieve the results            *;
      %***********************************;
      results.callIntMethod("getReturnCode", returnCode);
      results.callStringMethod("getReturnMessage", message);

      %***********************************;
      %* Process the results             *;
      %***********************************;
      logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
	  %if ("&lsaf_runAsTest" eq "1") %then 
	  %do;
	     testLogMsg = " test ";
	  %end;
	  %else
	  %do;
	     testLogMsg = "";
	  %end;
      if (returnCode ne 0) then
      do;
         logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
         logMsg=" Cannot submit" || testLogMsg || "job &lsaf_path.";
      end;
      else
      do;
         logMsgPrimary=logMsgPrefix;
         logMsg=" Submitted" || testLogMsg || "job &lsaf_path.";
      end;

      %***********************************;
      %* Print messages in log           *;
      %***********************************;
      put;
      put logMsgPrimary " " logMsg;
      put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
      put logMsgPrefix " _lsafMsg_= " message ;
      put logMsgPrefix " _lsafRC_= " returnCode ;
      if ("&sas_dsname" = "") 
        then put logMsgPrefix "No job parameters were supplied.";
        else put logMsgPrefix "sas_dsname = &sas_dsname";
      put logMsgPrefix "_lsafWorkspaceJobSubmissionId_= " jobSubmissionId;
      put;

      %***********************************;
      %* Set the macro variables         *;
      %***********************************;
      call symputx("_lsafRC_", returnCode);
      call symputx("_lsafMsg_", message);
      call symputx("_lsafWorkspaceJobSubmissionId_", strip(jobSubmissionId));

   run;

   %return;

   %PRINT_DSERROR_LOG_MSGS:
      options &notesOption.;
      %put &logMsgPrimary  &macroName ;
      %put &logMsgPrefix _lsafRC_= &_lsafRC_ ;
      %put &logMsgPrefix _lsafMsg_= &_lsafMsg_ ;
      %put &logMsgPrefix Parameter data set = &sas_dsname;
      %put;
      
%mend lsaf_submitworkspacejob;
