%* lsaf_studytlfexists                                               *;
%*                                                                   *;
%* Indicates whether a TLF exists within the specified study.        *;
%*                                                                   *;
%* macrotype LSAF                                                    *;
%* since 2.5                                                         *;
%* exposure external                                                 *;
%*                                                                   *;
%* History                                                           *;
%* 2021-03-24  intial coding                                         *;
%* 2021-08-17  Remove header documentation                           *;
%*                                                                   *;

%macro lsaf_studytlfexists(
  lsaf_studyId=, 
  lsaf_basestandardname=,
  lsaf_modelId=,
  lsaf_tlfIdentifier=
  ) /des='Does the tlf exist in the study?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_
          _lsafStudyTlfExists_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/tlf/StudyTlfService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("tlfExists", "%bquote(&lsaf_studyId)", "%bquote(&lsaf_basestandardname)", "%bquote(&lsaf_modelId)", 
		"%bquote(&lsaf_tlfIdentifier)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the tlf exists: &lsaf_tlfIdentifier." ;
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) then
      do;
        logMsg=" The tlf exists: &lsaf_tlfIdentifier." ;
      end;
      else
      do;
        logMsg=" The tlf does not exist: &lsaf_tlfIdentifier." ;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafStudyTlfExists_= " exists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafStudyTlfExists_", exists) ;

  run;

%mend lsaf_studytlfexists ;
