%* lsaf_studytlfautoflowenabled                                         *;
%*                                                                      *;
%* Indicates whether a TLF autoflowenabled within the specified study.  *;
%*                                                                      *;
%* macrotype LSAF                                                       *;
%* since 2.5                                                            *;
%* exposure external                                                    *;
%*                                                                      *;
%* History                                                              *;
%* 2021-03-24  intial coding                                            *;
%* 2021-08-17  Remove header documentation                              *;
%*                                                                      *;

%macro lsaf_studytlfautoflowenabled(
  lsaf_studyId=, 
  lsaf_basestandardname=,
  lsaf_modelId=,
  lsaf_tlfIdentifier=
  ) /des='Is the tlf autoflow enabled?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_
          _lsafStudyTlfAutoflowEnabled_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode       length=8;
    attrib message          length=$200;
    attrib logMsgPrefix     length=$70;
    attrib logMsg           length=$300;
    attrib autoflowenabled  length=3;
    attrib logMsgPrimary    length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/tlf/StudyTlfService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("tlfAutoflowEnabled", "%bquote(&lsaf_studyId)", "%bquote(&lsaf_basestandardname)", "%bquote(&lsaf_modelId)", 
		"%bquote(&lsaf_tlfIdentifier)", results, autoflowenabled);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the tlf is autoflowenabled: &lsaf_tlfIdentifier." ;
      autoflowenabled=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (autoflowenabled) then
      do;
        logMsg=" The tlf is autoflowenabled: &lsaf_tlfIdentifier." ;
      end;
      else
      do;
        logMsg=" The tlf is not autoflowenabled: &lsaf_tlfIdentifier." ;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafStudyTlfautoflowenabled_= " autoflowenabled;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafStudyTlfautoflowenabled_", autoflowenabled) ;

  run;

%mend lsaf_studytlfautoflowenabled ;
