%* lsaf_setitemsubscriptions                                                                      *;
%*                                                                                                *;
%* Sets the event subscriptions for a job file for the current user.                              *;
%*                                                                                                *;
%* macrotype LSAF                                                                                 *;
%* since 2.3                                                                                      *;
%* exposure external                                                                              *;
%*                                                                                                *;
%* History                                                                                        *;
%* 2020-02-12  initial coding                                                                     *;
%* 2020-07-13  update for refactor of java service hierarchy.                                     *;
%* 2021-08-17  Remove header documentation                                                        *;
%* 2021-10-13  US11739                                                                            *;
%*                                                                                                *;

%macro lsaf_setitemsubscriptions(
  lsaf_path=, 
  lsaf_events=,
  sas_dsname=work.lsafSetItemSubscriptions
  ) /des='Sets a list of subscriptions for the current user';
  
  %if "&sas_dsname" EQ "" %then %let sas_dsname=work.lsafSetItemSubscriptions;

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %local _lsafRowCount_
         notesOption
  ;

  %**********************************************;
  %*  Start the datastep to call the java code  *;
  %**********************************************;
  data &sas_dsname (label="Created by &SYSMACRONAME" keep=event path);
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           rowCount        length=8

           event           length=$64       label="Event Name"
           path            length=$2048     label="Path"
     ;

    rowCount=0;

    %***********************************;
    %* Declare the java files          *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/messaging/subscription/SubscriptionService");
    declare javaobj results("com/sas/lsaf/macro/messaging/subscription/SasSubscriptionsResult");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("setSubscriptions", "%bquote(&lsaf_path)", "%bquote(&lsaf_events)",  results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot retrieve subscriptions" ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Subscriptions were returned for the current user" ;
      results.callIntMethod("getSize", rowCount);
      do row=0 to rowCount - 1;
        results.callStringMethod("getEvent", row, event);
        results.callStringMethod("getPath", row, path);
        output;
      end;
    end;
    
    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    if (rowCount=0) 
      then put logMsgPrefix " No subscriptions were found.";
      else put logMsgPrefix " " rowCount " records written to data set &sas_dsname";
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafRowCount_", rowCount);

  run;

  %***********************************;
  %* Sort the data set               *;
  %***********************************;
  %if (&_lsafRowCount_ > 0) %then
  %do;
   %let notesOption=%sysfunc(getoption(notes));
    options nonotes;
    proc sort data=&sas_dsname sortseq=linguistic(strength=primary);
      by event path;
    run;
    options &notesOption;
  %end;

%mend lsaf_setitemsubscriptions;