%* lsaf_set_lsafmsg_from_sysmsg.sas                                                    *;
%*                                                                                     *;
%* Supports lsaf_validate_sasdataset_name.                                             *;
%*                                                                                     *;
%* macrotype LSAF                                                                      *;
%* since 2.5                                                                           *;
%* exposure internal                                                                   *;
%*                                                                                     *;
%* History                                                                             *;
%* 2021-04-20  initial creation                                                        *;
%* 2021-08-18  Update header documentation                                             *;
%*                                                                                     *;

%macro lsaf_set_lsafmsg_from_sysmsg(sysMsg);
   	%let notesOption=%sysfunc(getoption(notes));
   	options nonotes;
	data _null_;
		fullSysMsg = strip("&sysMsg.");
		subIndex = 0;
		if (indexc(fullSysMsg, "ERROR:") eq 1) then
			subIndex = 7;
		else if (indexc(fullSysMsg, "WARNING:") eq 1) then
			subIndex = 9;
		else if (indexc(fullSysMsg, "NOTE:") eq 1) then
			subIndex = 6;
	    * put fullSysMsg=;
	    * put subIndex=;
		if (subIndex > 0) then
			fullSysMsg = substr(fullSysMsg, subIndex);

		call symput("_lsafMsg_", "&__errorMsg__." || fullSysMsg);
	run;
	options &notesOption;
%mend;
