%* lsaf_sessionexists                                                                       *;
%*                                                                                          *;
%* Indicates whether a session exists.                                                      *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 2.3                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2019-12-02  initial code                                                                 *;
%* 2021-08-16  Remove header documentation                                                  *;
%*                                                                                          *;

%macro lsaf_sessionexists(
  lsaf_sessionid=
  ) /des='Does the session exist?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_         
          _lsafRC_
          _lsafSessionExists_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib sessionexists   length=3;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/execution/session/SessionService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("sessionExists", "%bquote(&lsaf_sessionid)", results, sessionexists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if session &lsaf_sessionid exists." ;
      sessionexists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (sessionexists) then
      do;
        logMsg=" Session &lsaf_sessionid exists." ;
      end;
      else
      do;
        logMsg=" Session &lsaf_sessionid does not exists." ;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafSessionExists_= " sessionexists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafSessionExists_", sessionexists) ;

  run;

%mend lsaf_sessionexists ;
