%* lsaf_scheduleexistsbyid                                                                  *;
%*                                                                                          *;
%* Indicates whether a schedule with the specified identifier exists.                       *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 2.3                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2019-10-01  initial code                                                                 *;
%* 2020-06-30  update service location                                                      *;
%* 2021-08-16  Remove header documentation                                                  *;
%*                                                                                          *;

%macro lsaf_scheduleexistsbyid(
  lsaf_scheduleid=
  ) /des='Does the schedule exist by the specified id?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_         
          _lsafRC_
          _lsafScheduleExistsById_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/execution/schedule/ScheduleService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("scheduleExistsById", "%bquote(&lsaf_scheduleid)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the schedule exists by id: &lsaf_scheduleid." ;
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) then
      do;
        logMsg=" The schedule exists with id &lsaf_scheduleid." ;
      end;
      else
      do;
        logMsg=" The schedule does not exist with id &lsaf_scheduleid." ;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafScheduleExistsById_= " exists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafScheduleExistsById_", exists) ;

  run;

%mend lsaf_scheduleexistsbyid ;
