%* lsaf_renameworkspaceitem                                                                      *;
%*                                                                                               *;
%* Renames a workspace file or folder to the specified name.                                     *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.5                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2021-02-08  initial coding                                                                    *;
%* 2021-07-12  changed call to allow for return of new path                                      *;
%* 2021-08-18  Remove header documentation                                                       *;
%* 2021-12-07  2.6, US11644 - return renamed path                                                *;
%*                                                                                               *;

%macro lsaf_renameworkspaceitem(
  lsaf_source=,
  lsaf_newname=
  ) /des='rename a workspace file or folder.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
          _lsafRenamedWorkspaceItem_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %*  Start the datastep to call the java code  *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
	
    attrib newPath         length=$2048;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/workspace/WorkspaceService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
	srv.callStaticStringMethod("rename", "%bquote(&lsaf_source)", "%bquote(&lsaf_newname)", results, newPath);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The rename operation was successful.";
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot successfully rename the item." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put logMsgPrefix " lsaf_source = &lsaf_source" ;
    put logMsgPrefix " lsaf_newname = &lsaf_newname" ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafRenamedWorkspaceItem_", strip(newPath));

  run;

%mend lsaf_renameworkspaceitem ;
