%* lsaf_removeinheritedrole                                                                       *;
%*                                                                                                *;
%* Removes a role from the specified context.                                                     *;
%*                                                                                                *;
%* macrotype LSAF                                                                                 *;
%* since 1.2                                                                                      *;
%* exposure external                                                                              *;
%*                                                                                                *;
%* History                                                                                        *;
%* 2013-08-30  updates for standardization and coding conventions                                 *;
%* 2016-08-26  rebrand as LSAF                                                                    *;
%* 2019-01-30  update to 2.1                                                                      *;
%* 2019-02-14  rename from lsaf_unassignrole                                                      *;
%* 2020-12-07  updates for service refactor                                                       *;
%* 2021-08-13  Remove header documentation                                                        *;
%* 2021-08-30  Updated for java refactor: sasRole                                                 *;
%*                                                                                                *;

%macro lsaf_removeinheritedrole(
  lsaf_path=,
  lsaf_role=,
  lsaf_role_context=
  ) /des='Remove a role from a context.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj role("com/sas/lsaf/macro/security/role/SasRole", "%bquote(&lsaf_path)", "%bquote(&lsaf_role)", "%bquote(&lsaf_role_context)");
    declare javaobj srv("com/sas/lsaf/macro/security/role/RoleService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticVoidMethod("removeInheritedRole", role, results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode eq 0) then
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" * The role &lsaf_role from context &lsaf_role_context was removed from &lsaf_path" ;
    end;
    else
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot remove role &lsaf_role from context &lsaf_role_context from &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_removeinheritedrole ;
