%* lsaf_queryrecyclebinfileversion                                                                          *;
%*                                                                                                          *;
%* Extracts individual files that have been deleted and that reside in a recycle bin, based on the          *;
%* specified query. The query is contained in a SAS data set. The extracted data is stored in a file that   *;
%* is located in your workspace or in the repository. Each item is in a separate row.                       *;
%*                                                                                                          *;
%* macrotype LSAF                                                                                           *;
%* since 2.4                                                                                                *;
%* exposure internal                                                                                        *;
%*                                                                                                          *;
%* History                                                                                                  *;
%* 2020-11-04  initial coding                                                                               *;
%* 2020-11-30  updated for version handling.                                                                *;
%* 2021-08-12  Remove header documentation                                                                  *;
%* 2021-10-25  Updates for US11739                                                                          *;
%*                                                                                                          *;

%macro lsaf_queryrecyclebinfileversion(
  lsaf_querydataset=,
  lsaf_validateddataset=work.lsafqueryrecyclebinfileversion,
  lsaf_exportlocation=,
  lsaf_exportpath=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Performs a query and returns an output file to a specified location in the SAS Life Science Analytics Framework.';

  %if "&lsaf_validateddataset" EQ "" %then %let lsaf_validateddataset=work.lsafqueryrecyclebinfileversion;
  %let macName = %sysfunc(lowcase(&SYSMACRONAME));
  
  %lsaf_query(lsaf_callingMacro=&macName,
              lsaf_queryMethod=%str(executeRecycleBinFileVersionQuery),
              lsaf_returnPathVar=%str(_lsafRBFileVersionExportPath_),
              lsaf_querydataset=&lsaf_querydataset,
              lsaf_validateddataset=&lsaf_validateddataset,
              lsaf_exportlocation=&lsaf_exportlocation,
              lsaf_exportpath=&lsaf_exportpath,
              lsaf_overwrite=&lsaf_overwrite,
              lsaf_enableversioning=&lsaf_enableversioning,
              lsaf_versiontype=&lsaf_versiontype,
              lsaf_customversion=&lsaf_customversion,
              lsaf_comment=&lsaf_comment
  );

%mend lsaf_queryrecyclebinfileversion;
