%* lsaf_queryitem                                                                                           *;
%*                                                                                                          *;
%* Extracts information about a file or container that is in the repository to a file based on the          *;
%* specified query. The query is contained in a SAS data set. The extracted data is stored in a file that   *;
%* is located in your workspace or in the repository. Each item is in a separate row. The results do not    *;
%* include content that is in the /Users folder.                                                            *;
%*                                                                                                          *;
%* macrotype LSAF                                                                                           *;
%* since 2.4                                                                                                *;
%* exposure external                                                                                        *;
%*                                                                                                          *;
%* History                                                                                                  *;
%* 2020-07-14  initial coding                                                                               *;
%* 2020-11-30  updated for version handling.                                                                *;
%* 2021-08-12  Remove header documentation                                                                  *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                          *;
%*                                                                                                          *;

%macro lsaf_queryitem(
  lsaf_querydataset=,
  lsaf_validateddataset=work.lsafqueryitem,
  lsaf_exportlocation=,
  lsaf_exportpath=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Performs a query and returns an output file to a specified location in the SAS Life Science Analytics Framework.';

  %if "&lsaf_validateddataset" EQ "" %then %let lsaf_validateddataset=work.lsafqueryitem;
  %let macName = %sysfunc(lowcase(&SYSMACRONAME));
  
  %lsaf_query(lsaf_callingMacro=&macName,
              lsaf_queryMethod=%str(executeRepositoryItemQuery),
              lsaf_returnPathVar=%str(_lsafItemExportPath_),
              lsaf_querydataset=&lsaf_querydataset,
              lsaf_validateddataset=&lsaf_validateddataset,
              lsaf_exportlocation=&lsaf_exportlocation,
              lsaf_exportpath=&lsaf_exportpath,
              lsaf_overwrite=&lsaf_overwrite,
              lsaf_enableversioning=&lsaf_enableversioning,
              lsaf_versiontype=&lsaf_versiontype,
              lsaf_customversion=&lsaf_customversion,
              lsaf_comment=&lsaf_comment
  );

%mend lsaf_queryitem;
