%* lsaf_querydefaultpermissions                                                                             *;
%*                                                                                                          *;
%* Extracts the default effective permissions for items in the repository.                                  *;
%*                                                                                                          *;
%* macrotype LSAF                                                                                           *;
%* since 2.6                                                                                                *;
%* exposure internal                                                                                        *;
%*                                                                                                          *;
%* History                                                                                                  *;
%* 2021-12-01  initial coding                                                                               *;
%*                                                                                                          *;

%macro lsaf_querydefaultpermissions(
  lsaf_querydataset=,
  lsaf_validateddataset=,
  lsaf_exportlocation=,
  lsaf_exportpath=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Extract the default effective permissions for items in the repository in the SAS Life Science Analytics Framework.';

  %if "&lsaf_validateddataset" EQ "" %then %let lsaf_validateddataset=work.lsafquerydefaultpermissions;
  %let macName = %sysfunc(lowcase(&SYSMACRONAME));
  
  %lsaf_query(lsaf_callingMacro=&macName,
              lsaf_queryMethod=%str(executeDefaultPermissionsQuery),
              lsaf_returnPathVar=%str(_lsafdefpermissionsexportpath_),
              lsaf_querydataset=&lsaf_querydataset,
              lsaf_validateddataset=&lsaf_validateddataset,
              lsaf_exportlocation=&lsaf_exportlocation,
              lsaf_exportpath=&lsaf_exportpath,
              lsaf_overwrite=&lsaf_overwrite,
              lsaf_enableversioning=&lsaf_enableversioning,
              lsaf_versiontype=&lsaf_versiontype,
              lsaf_customversion=&lsaf_customversion,
              lsaf_comment=&lsaf_comment
  );

%mend lsaf_querydefaultpermissions;
