%* lsaf_querycontainer                                                                                      *;
%*                                                                                                          *;
%* Extracts repository container information to a file based on the specified query. The query is contained *;
%* in a SAS data set. The extracted data is stored in a comma-separated values file that is located in      *;
%* your workspace or in the repository.                                                                     *;
%*                                                                                                          *;
%* macrotype LSAF                                                                                           *;
%* since 2.4                                                                                                *;
%* exposure external                                                                                        *;
%*                                                                                                          *;
%* History                                                                                                  *;
%* 2020-07-16  initial coding                                                                               *;
%* 2020-11-30  updated for version handling.                                                                *;
%* 2021-08-12  Remove header documentation                                                                  *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                          *;
%*                                                                                                          *;

%macro lsaf_querycontainer(
  lsaf_querydataset=,
  lsaf_validateddataset=work.lsafquerycontainer,
  lsaf_exportlocation=,
  lsaf_exportpath=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Performs a query and returns an output file to a specified location in the SAS Life Science Analytics Framework.';

  %if "&lsaf_validateddataset" EQ "" %then %let lsaf_validateddataset=work.lsafquerycontainer;
  %let macName = %sysfunc(lowcase(&SYSMACRONAME));
  
  %lsaf_query(lsaf_callingMacro=&macName,
              lsaf_queryMethod=%str(executeRepositoryContainerQuery),
              lsaf_returnPathVar=%str(_lsafContainerExportPath_),
              lsaf_querydataset=&lsaf_querydataset,
              lsaf_validateddataset=&lsaf_validateddataset,
              lsaf_exportlocation=&lsaf_exportlocation,
              lsaf_exportpath=&lsaf_exportpath,
              lsaf_overwrite=&lsaf_overwrite,
              lsaf_enableversioning=&lsaf_enableversioning,
              lsaf_versiontype=&lsaf_versiontype,
              lsaf_customversion=&lsaf_customversion,
              lsaf_comment=&lsaf_comment
  );

%mend lsaf_querycontainer;
