%* lsaf_queryauditentries                                                                                   *;
%*                                                                                                          *;
%* Extracts audit entries from the audit history records. The entries to extract are specified in a query   *;
%* that is contained in a data set. The extracted data is stored in a comma-separated values file that      *;
%* is located in your workspace or in the repository.                                                       *;  
%*                                                                                                          *;
%* macrotype LSAF                                                                                           *;
%* since 2.3                                                                                                *;
%* exposure internal                                                                                        *;
%*                                                                                                          *;
%* History                                                                                                  *;
%* 2020-03-03  initial coding                                                                               *;
%* 2020-11-30  updated for version handling.                                                                *;
%* 2021-08-12  Remove header documentation                                                                  *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                          *;
%*                                                                                                          *;

%macro lsaf_queryauditentries(
  lsaf_querydataset=,
  lsaf_validateddataset=work.lsafqueryauditentries,
  lsaf_exportlocation=,
  lsaf_exportpath=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Performs a query and returns an output file to a specified location in the SAS Life Science Analytics Framework.';

  %if "&lsaf_validateddataset" EQ "" %then %let lsaf_validateddataset=work.lsafqueryauditentries;
  %let macName = %sysfunc(lowcase(&SYSMACRONAME));
  
  %lsaf_query(lsaf_callingMacro=&macName,
              lsaf_queryMethod=%str(executeAuditEntryQuery),
              lsaf_returnPathVar=%str(_lsafauditentriesexportpath_),
              lsaf_querydataset=&lsaf_querydataset,
              lsaf_validateddataset=&lsaf_validateddataset,
              lsaf_exportlocation=&lsaf_exportlocation,
              lsaf_exportpath=&lsaf_exportpath,
              lsaf_overwrite=&lsaf_overwrite,
              lsaf_enableversioning=&lsaf_enableversioning,
              lsaf_versiontype=&lsaf_versiontype,
              lsaf_customversion=&lsaf_customversion,
              lsaf_comment=&lsaf_comment
  );

%mend lsaf_queryauditentries;
