%* lsaf_queryauditdetails                                                                                   *;
%*                                                                                                          *;
%* Extracts detailed data from entries that are in the audit history records. The detailed data to extract  *;
%* is specified in a query that is contained in a data set. The extracted data is stored in a               *;
%* comma-separated values file that is located in your workspace or in the repository. Each detail is in a  *;
%* separate row that includes the parent audit entry information.                                           *;  
%*                                                                                                          *;
%* macrotype LSAF                                                                                           *;
%* since 2.3                                                                                                *;
%* exposure internal                                                                                        *;
%*                                                                                                          *;
%* History                                                                                                  *;
%* 2020-03-30  initial coding                                                                               *;
%* 2020-11-30  updated for version handling.                                                                *;
%* 2021-08-12  Remove header documentation                                                                  *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                          *;
%*                                                                                                          *;

%macro lsaf_queryauditdetails(
  lsaf_querydataset=,
  lsaf_validateddataset=work.lsafqueryauditdetails,
  lsaf_exportlocation=,
  lsaf_exportpath=,
  lsaf_overwrite=,
  lsaf_enableversioning=,
  lsaf_versiontype=,
  lsaf_customversion=,
  lsaf_comment=
  ) /des='Performs a query and returns an output file to a specified location in the SAS Life Science Analytics Framework.';

  %if "&lsaf_validateddataset" EQ "" %then %let lsaf_validateddataset=work.lsafqueryauditdetails;
  %let macName = %sysfunc(lowcase(&SYSMACRONAME));
  
  %lsaf_query(lsaf_callingMacro=&macName,
              lsaf_queryMethod=%str(executeAuditEntryDetailQuery),
              lsaf_returnPathVar=%str(_lsafauditdetailsexportpath_),
              lsaf_querydataset=&lsaf_querydataset,
              lsaf_validateddataset=&lsaf_validateddataset,
              lsaf_exportlocation=&lsaf_exportlocation,
              lsaf_exportpath=&lsaf_exportpath,
              lsaf_overwrite=&lsaf_overwrite,
              lsaf_enableversioning=&lsaf_enableversioning,
              lsaf_versiontype=&lsaf_versiontype,
              lsaf_customversion=&lsaf_customversion,
              lsaf_comment=&lsaf_comment
  );

%mend lsaf_queryauditdetails;
