%* lsaf_processflowexists                                                                        *;
%*                                                                                               *;
%* Indicates whether a process flow is defined for the specified context.                        *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.5                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2016-08-17  initial development                                                               *;
%* 2019-02-12  update to 2.1                                                                     *;
%* 2021-08-12  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_processflowexists(
  lsaf_path=,
  lsaf_processflow=
  ) /des='Is the process flow defined in the context.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafProcessFlowExists_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib exists          length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/processflow/ProcessFlowService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("exists", "%bquote(&lsaf_path)", "%bquote(&lsaf_processflow)", results, exists);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine the existence of process flow &lsaf_processflow in &lsaf_path.." ;
      exists=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (exists) 
        then logMsg=" The process flow &lsaf_processflow was found in &lsaf_path.";
        else logMsg=" The process flow &lsaf_processflow was not found in &lsaf_path.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafProcessFlowExists_= " exists;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafProcessFlowExists_", exists) ;

  run;

%mend lsaf_processflowexists;
