%* lsaf_processdefdeployedatcontext                                                                      *;
%*                                                                                                       *;
%* Indicates whether a process flow definition is deployed at the specified context type.                *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 2.1                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2019-03-12  Initial coding                                                                            *;
%* 2021-08-10  Remove header documentation                                                               *;
%* 2021-12-06  2.6 US11676: Changed parameter to lsaf_processdefid                                       *;
%*                                                                                                       *;

%macro lsaf_processdefdeployedatcontext(
  lsaf_processdefid=,
  lsaf_typeid=
  ) /des='Has the process flow definition been deployed for the specified context type?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafPFDefDeployedAtContext_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           isDeployed      length=3
           ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/workflow/definition/ProcessDefinitionService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isProcessDefinitionDeployedForContextType", "%bquote(&lsaf_processdefid)", "%bquote(&lsaf_typeid)", results, isDeployed);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the process flow definition: &lsaf_processdefid is deployed for the specified context: &lsaf_typeid.." ;
      isDeployed=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isDeployed) 
        then logMsg=" The process flow definition: &lsaf_processdefid is deployed at context: &lsaf_typeid..";
        else logMsg=" The process flow definition: &lsaf_processdefid is not deployed at context: &lsaf_typeid..";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafPFDefDeployedAtContext_= " isDeployed;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafPFDefDeployedAtContext_", isDeployed) ;

  run;

%mend lsaf_processdefdeployedatcontext;
