%* lsaf_printwarningmessage                                                    *;
%*                                                                             *;
%* Determines, through user input, whether a warning message is printed to     *;
%* the SAS log file in the SAS Life Science Analytics Framework.               *;
%*                                                                             *;
%* This macro is called from lsaf_xxx macros that require the suppression of   *;
%* warning messages.                                                           *;
%*                                                                             *;
%* This macro returns _lsaf_PrintMessage_, which contains the resolved message *;
%* as a macro variable.                                                        *;  
%*                                                                             *;
%* Syntax:                                                                     *;
%* %LSAF_PRINTWARNINGMESSAGE(LSAF_PRINTMESSAGE=lsaf-printmessage);             *;
%*                                                                             *;
%* param lsaf_printmessage - Optional - Determines whether to print a warning  *;
%*        message to the SAS log file. Valid values:                           *;
%*        0: Do not print the warning.                                         *;
%*        1 (Default): Print the warning.                                      *;
%*                                                                             *;
%* macrotype LSAF                                                              *;
%* since 2.1                                                                   *;
%* exposure internal                                                           *;
%*                                                                             *;
%* History                                                                     *;
%* 2019-02-18  initial code                                                    *;
%* 2021-08-18  Update header documentation                                     *;
%*                                                                             *;

%macro lsaf_printwarningmessage(lsaf_printmessage=1) /des='Print a warning message to the log for LSAF';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %global _lsaf_PrintMessage;
  %let message= %str(&_LSAF_PRODUCT_NAME_ Macro: * LSAF maximum query limit has been reached. More items may exist that satisfy the query. Refine the search.);
  %if &lsaf_printmessage ne 0 
    %then %let _lsaf_PrintMessage_= %str(WARNING: &message);
    %else %let _lsaf_PrintMessage_=%str(NOTE: &message);

%mend lsaf_printwarningmessage;
