%* lsaf_printdeprecationmessage                                              *;
%*                                                                           *;
%* Prints the message regarding the deprecation of the current macro and     *;
%* the macro to replace it.                                                  *;
%*                                                                           *;
%* Syntax:                                                                   *;
%* %LSAF_PRINTDEPRECATIONMESSAGE(deprecatedmacro=, replacementmacro=);       *;
%*                                                                           *;
%* macrotype LSAF                                                            *;
%* since 2.6                                                                 *;
%* exposure internal                                                         *;
%*                                                                           *;
%* History                                                                   *;
%* 2021-11-05  initial code                                                  *;
%*                                                                           *;

%macro lsaf_printdeprecationmessage(
   deprecatedmacro=, 
   replacementmacro=
   )   /des='Print the deprecation message in the log.';

   %local replacedMsg;
   %let replacedMsg=;

   %if ("&replacementmacro" ne "") %then 
   %do;
      %let replacedMsg= %str(Please begin using macro %upcase(&REPLACEMENTMACRO.).);
   %end; 

   put;
   put "NOTE: *********************************************************************************************";
   put "NOTE: The %upcase(&DEPRECATEDMACRO.) macro will be deprecated in a future release of the ";
   put "NOTE: &_LSAF_PRODUCT_NAME_.. &replacedMsg ";
   put "NOTE: *********************************************************************************************";
   put;
%mend lsaf_printdeprecationmessage;
