%* lsaf_login                                                                                                   *;                                                                                                                                                                                                                   
%*                                                                                                              *;                                                                                                                                                                                                                   
%* Creates a connection to the SAS Life Science Analytics Framework instance.                                   *;                                                                                                                                                                                                                    
%*                                                                                                              *;                                                                                                                                                                                                                   
%* macrotype LSAF                                                                                               *;                                                                                                                                                                                                                   
%* since 1.1                                                                                                    *;                                                                                                                                                                                                                   
%* exposure external                                                                                            *;                                                                                                                                                                                                                   
%*                                                                                                              *;                                                                                                                                                                                                                   
%* History                                                                                                      *;                                                                                                                                                                                                                   
%* 2013-06-26  version 1.2 update - trusted session                                                             *;                                                                                                                                                                                                                   
%* 2013-08-30  updates for standardization and coding conventions                                               *;                                                                                                                                                                                                                   
%* 2014-03-04  updates for proxy                                                                                *;                                                                                                                                                                                                                   
%* 2016-08-26  rebrand as LSAF                                                                                  *; 
%* 2019-01-30  update to 2.1                                                                                    *;
%* 2020-02-07  move to AuthenticationService                                                                    *; 
%* 2020-07-14  update for refactor of java service hierarchy.                                                   *; 
%* 2021-08-05  Remove header documentation                                                                      *;
%*                                                                                                              *;                                                                                                                                                                                                                   
                                                                                                                                                                                                                                                                                                                                     
%macro lsaf_login(                                                                                                                                                                                                                                                                                                                   
  lsaf_url=,                                                                                                                                                                                                                                                                                                                         
  lsaf_userid=,                                                                                                                                                                                                                                                                                                                      
  lsaf_password=,                                                                                                                                                                                                                                                                                                                    
  proxy_host=,                                                                                                                                                                                                                                                                                                                       
  proxy_port=,                                                                                                                                                                                                                                                                                                                       
  proxy_userid=,                                                                                                                                                                                                                                                                                                                     
  proxy_password=                                                                                                                                                                                                                                                                                                                    
  ) /des='Initialize connection to SAS Life Science Analytics Framework.';                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
  %****************************************;                                                                                                                                                                                                                                                                                         
  %* Initialize macro variables           *;                                                                                                                                                                                                                                                                                         
  %****************************************;                                                                                                                                                                                                                                                                                         
  %lsaf_getProductName();                                                                                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                                                                                                                     
  %global _lsafMsg_                                                                                                                                                                                                                                                                                                                  
          _lsafRC_                                                                                                                                                                                                                                                                                                                   
  ;                                                                                                                                                                                                                                                                                                                                  
                                                                                                                                                                                                                                                                                                                                     
  %let _lsafRC_ =%str(-999);                                                                                                                                                                                                                                                                                                         
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                                                                                                                                                                                                
                                                                                                                                                                                                                                                                                                                                     
  %**********************************************;                                                                                                                                                                                                                                                                                   
  %* Start the datastep to call the java code   *;                                                                                                                                                                                                                                                                                   
  %**********************************************;                                                                                                                                                                                                                                                                                   
  data _null_;                                                                                                                                                                                                                                                                                                                       
    attrib returnCode      length=8;                                                                                                                                                                                                                                                                                                 
    attrib message         length=$200;                                                                                                                                                                                                                                                                                              
    attrib logMsgPrefix    length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsgPrimary   length=$70;                                                                                                                                                                                                                                                                                               
    attrib logMsg          length=$300;                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Declare the java objects        *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    declare javaobj srv("com/sas/lsaf/macro/security/authentication/AuthenticationService");                                                                                                                                                                                                                                                                 
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Attempt the operation           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    srv.callStaticVoidMethod("login", "%bquote(&lsaf_url)", "%bquote(&lsaf_userid)", "%bquote(&lsaf_password)",                                                                                                                                                                                                                      
         "%bquote(&proxy_host)", "%bquote(&proxy_port)", "%bquote(&proxy_userid)", "%bquote(&proxy_password)", results);                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Retrieve the results            *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    results.callIntMethod("getReturnCode", returnCode);                                                                                                                                                                                                                                                                              
    results.callStringMethod("getReturnMessage", message);                                                                                                                                                                                                                                                                           
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Process the results             *;                                                                                                                                                                                                                                                                                            
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then                                                                                                                                                                                                                                                                                                        
    do;                                                                                                                                                                                                                                                                                                                              
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";                                                                                                                                                                                                                                                                       
      logMsg="Could not login to the &_LSAF_PRODUCT_NAME_ Server." ;                                                                                                                                                                                                                                                                 
    end;                                                                                                                                                                                                                                                                                                                             
    else                                                                                                                                                                                                                                                                                                                             
    do;                                                                                                                                                                                                                                                                                                                              
      logMsgPrimary=logMsgPrefix;                                                                                                                                                                                                                                                                           
      logMsg="&_LSAF_PRODUCT_NAME_ Session initialized.";                                                                                                                                                                                                                                                                            
    end;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Print messages in log           *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    put;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrimary " " logMsg;                                                                                                                                                                                                                                                                                                     
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                                                                                                                                                                                                         
    put logMsgPrefix " url= &lsaf_url";                                                                                                                                                                                                                                                                                              
    put logMsgPrefix " userid= &lsaf_userid";                                                                                                                                                                                                                                                                                        
    if (klength(kstrip("&proxy_host")) > 0) then                                                                                                                                                                                                                                                                                     
    do;                                                                                                                                                                                                                                                                                                                              
       put logMsgPrefix " proxy host= &proxy_host";                                                                                                                                                                                                                                                                                  
       put logMsgPrefix " proxy port= &proxy_port";                                                                                                                                                                                                                                                                                  
       put logMsgPrefix " proxy_userid= &proxy_userid";                                                                                                                                                                                                                                                                              
    end;                                                                                                                                                                                                                                                                                                                             
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                                                                                                                                                                                                         
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                                                                                                                                                                                                       
    put;                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                     
    %***********************************;                                                                                                                                                                                                                                                                                            
    %* Set the macro variables         *;                                                                                                                                                                                                                                                                                            
    %***********************************;                                                                                                                                                                                                                                                                                            
    call symputx("_lsafRC_", returnCode);                                                                                                                                                                                                                                                                                            
    call symputx("_lsafMsg_", message);                                                                                                                                                                                                                                                                                              
                                                                                                                                                                                                                                                                                                                                     
  run;                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                     
%mend lsaf_login;                                                                                                                                                                                                                                                                                                                   
