%* lsaf_linksharedfolder                                                                    *;
%*                                                                                          *;
%* Grants access to the specified shared workspace folder for the specified context member. *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 2.7                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2024-08-15  initial code                                                                 *;
%*                                                                                          *;

%macro lsaf_linksharedfolder(
  lsaf_sharedfolderid=,
  lsaf_member=
  ) /des='Creates a link to a shared folder.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
		  _lsafSharedFolderPath_
  ;

  %let _lsafRC_=%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsg          length=$300
           logMsgPrimary   length=$70
		   path            length=$2048
    ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj cmd("com/sas/lsaf/macro/content/workspace/SharedWorkspaceService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    cmd.callStaticStringMethod("createLink", "%bquote(&lsaf_sharedfolderid)", "%bquote(&lsaf_member)", results, path);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    logMsgPrimary=logMsgPrefix;
    logMsg=" The link to shared folder &lsaf_sharedfolderid was created for &lsaf_member." ;
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" The link to shared folder &lsaf_sharedfolderid was not created for &lsaf_member." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
	call symputx("_lsafSharedFolderPath_", strip(path));

  run;

%mend lsaf_linksharedfolder ;
