%* lsaf_isversionsigned                                                                                *;
%*                                                                                                     *;
%* Indicates whether the specified version of a file in the repository is signed.                      *;
%*                                                                                                     *;
%* macrotype LSAF                                                                                      *;
%* since 2.1                                                                                           *;
%* exposure external                                                                                   *;
%*                                                                                                     *;
%* History                                                                                             *;
%* 2019-02-04  initial coding                                                                          *;
%* 2020-07-13  update for refactor of java service hierarchy.                                          *;
%* 2021-08-16  Remove header documentation                                                             *;
%*                                                                                                     *;

%macro lsaf_isversionsigned(
  lsaf_path=,
  lsaf_version=
  ) /des='Is the version of the file signed?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsVersionSigned_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode          length=8;
    attrib message             length=$200;
    attrib logMsgPrefix        length=$70;
    attrib logMsg              length=$300;
    attrib isVersionSigned     length=3;
    attrib logMsgPrimary       length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/signature/SignatureService") ;
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isVersionSigned", "%bquote(&lsaf_path)", "%bquote(&lsaf_version)", results, isVersionSigned);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the file is signed for version: &lsaf_version." ;
      isVersionSigned=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isVersionSigned) 
        then logMsg=" The file is signed for version: &lsaf_version.";
        else logMsg=" The file is not signed for version: &lsaf_version.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsVersionSigned_= " isVersionSigned;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsVersionSigned_", isVersionSigned);

  run;

%mend lsaf_isversionsigned;
