%* lsaf_isuserlocked                                                                          *;
%*                                                                                            *;
%* Indicates whether a user account is locked.                                                *;
%*                                                                                            *;
%* macrotype LSAF                                                                             *;
%* since 2.3                                                                                  *;
%* exposure external                                                                          *;
%*                                                                                            *;
%* History                                                                                    *;
%* 2019-12-16  initial coding                                                                 *;
%* 2020-12-04  updates for service refactor                                                   *;
%* 2021-08-18  Remove header documentation                                                    *;
%*                                                                                            *;

%macro lsaf_isuserlocked(
  lsaf_userid=
  ) /des='Is the user locked?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsUserLocked_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib isLocked        length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/user/UserService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isLocked", "%bquote(&lsaf_userid)", results, isLocked);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the user: &lsaf_userid. is locked." ;
      isLocked=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isLocked) then
      do;
        logMsg=" The user &lsaf_userid. is locked.";
      end;
      else
      do;
        logMsg=" The user &lsaf_userid. is not locked.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsUserLocked_= " isLocked;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsUserLocked_", isLocked) ;

  run;

%mend lsaf_isuserlocked;
