%* lsaf_isstudydictionary                                                                              *;
%*                                                                                                     *;
%* Indicates whether a controlled terminology dictionary is associated with a study.                   *;
%*                                                                                                     *;
%* macrotype LSAF                                                                                      *;
%* since 2.2                                                                                           *;
%* exposure external                                                                                   *;
%*                                                                                                     *;
%* History                                                                                             *;
%* 2019-08-23  initial coding                                                                          *;
%* 2021-08-16  Remove header documentation                                                             *;
%*                                                                                                     *;

%macro lsaf_isstudydictionary(
  lsaf_studyid=,
  lsaf_dictionaryid=
  ) /des='Is the controlled terminology dictionary associated with a SAS Life Science Analytics Framework study?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsStudyDictionary_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode        length=8;
    attrib message           length=$200;
    attrib logMsgPrefix      length=$70;
    attrib logMsgPrimary     length=$70;
    attrib logMsg            length=$300;
    attrib isStudyDictionary length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/StudyService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isStudyDictionary", "%bquote(&lsaf_studyid)", "%bquote(&lsaf_dictionaryid)", results, isStudyDictionary);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the dictionary is associated to the study." ;
      isStudyDictionary=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isStudyDictionary) then
      do;
        logMsg=" The controlled terminology dictionary is associated with the study.";
      end;
      else
      do;
        logMsg=" The controlled terminology dictionary is NOT associated with the study.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsStudyDictionary_= " isStudyDictionary;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsStudyDictionary_", isStudyDictionary);

  run;

%mend lsaf_isstudydictionary;
