%* lsaf_issharedfolder                                           *;
%*                                                               *;
%* Indicates whether a repository item is a shared folder.       *;
%*                                                               *;
%* macrotype LSAF                                                *;
%* since 2.7                                                     *;
%* exposure external                            	             *;
%*                                                               *;
%* History                                                       *;
%* 2024-08-19  intial coding                                     *;
%*                                                               *;

%macro lsaf_issharedfolder(
  lsaf_path=
  ) /des='Is the item a shared folder?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsSharedFolder_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8
           message         length=$200
           logMsgPrefix    length=$70
           logMsgPrimary   length=$70
           logMsg          length=$300
           isSharedFolder  length=3
    ;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isSharedFolder", "%bquote(&lsaf_path)", results, isSharedFolder);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the item is a shared folder: &lsaf_path." ;
      isSharedFolder=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isSharedFolder) then
      do;
        logMsg=" The item is a shared folder: &lsaf_path.";
      end;
      else
      do;
        logMsg=" The item is not a shared folder: &lsaf_path.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsSharedFolder_= " isSharedFolder;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsSharedFolder_", isSharedFolder);

  run;

%mend lsaf_issharedfolder;
