%* lsaf_isroleprivilege                                                                          *;
%*                                                                                               *;
%* Indicates whether a privilege is assigned to a role in the specified context.                 *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.2                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2013-08-30  updates for standardization and coding conventions                                *;
%* 2016-08-26  rebrand as LSAF                                                                   *;
%* 2019-01-30  update to 2.1                                                                     *;
%* 2020-12-07  updates for service refactor                                                      *;
%* 2021-08-13  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_isroleprivilege(
  lsaf_path=,
  lsaf_role=,
  lsaf_privilege=
  ) /des='Is the privilege in the role in the specified context?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsRolePrivilege_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib hasPrivilege    length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/role/RoleService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("hasPrivilege", "%bquote(&lsaf_path)", "%bquote(&lsaf_role)", "%bquote(&lsaf_privilege)", results, hasPrivilege);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if &lsaf_privilege is assigned to the role &lsaf_role in &lsaf_path..";
      hasPrivilege=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (hasPrivilege) 
        then logMsg=" &lsaf_privilege is assigned to the role &lsaf_role in &lsaf_path.." ;
        else logMsg=" &lsaf_privilege is not assigned to the role &lsaf_role in &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsRolePrivilege_= " hasPrivilege;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsRolePrivilege_", hasPrivilege);

  run;

%mend lsaf_isroleprivilege;
