%* lsaf_isrolemember                                                                               *;
%*                                                                                                 *;
%* Indicates whether a user account or user group is a member of a role in the specified context.  *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 1.2                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2013-08-30  updates for standardization and coding conventions                                  *;
%* 2016-08-26  rebrand as LSAF                                                                     *;
%* 2019-01-30  update to 2.1                                                                       *;
%* 2020-12-07  updates for service refactor                                                        *;
%* 2021-08-13  Remove header documentation                                                         *;
%* 2021-08-30  Updated for java refactor: sasRole                                                  *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                 *;
%* 2021-10-21  principal refactor                                                                  *;
%*                                                                                                 *;

%macro lsaf_isrolemember(
  lsaf_path=,
  lsaf_role=,
  lsaf_role_context=,
  lsaf_member=,
  lsaf_type=,
  lsaf_group_context=
  ) /des='Is the user or group a member of the role in the specified context?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsRoleMember_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib hasMember       length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj role("com/sas/lsaf/macro/security/role/SasRole", "%bquote(&lsaf_path)", "%bquote(&lsaf_role)", "%bquote(&lsaf_role_context)");
	declare javaobj member("com/sas/lsaf/macro/security/SasPrincipalDescriptor", 
                           "%bquote(&lsaf_type)", "%bquote(&lsaf_member)", "%bquote(&lsaf_group_context)");
    declare javaobj srv("com/sas/lsaf/macro/security/role/RoleService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("hasMember", role, member, results, hasMember);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if &lsaf_type &lsaf_member is a member of the role &lsaf_role in &lsaf_path..";
      hasMember=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (hasMember) 
        then logMsg=" The &lsaf_type &lsaf_member is a member of the role &lsaf_role in &lsaf_path.." ;
        else logMsg=" The &lsaf_type &lsaf_member is not a member of the role &lsaf_role in &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsRoleMember_= " hasMember;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsRoleMember_", hasMember) ;

  run;

%mend lsaf_isrolemember;
