%* lsaf_isjobscheduled                                                                      *;
%*                                                                                          *;
%* Indicates whether a job is scheduled.                                                    *;
%*                                                                                          *;
%* macrotype LSAF                                                                           *;
%* since 2.3                                                                                *;
%* exposure external                                                                        *;
%*                                                                                          *;
%* History                                                                                  *;
%* 2019-11-20  initial code                                                                 *;
%* 2020-06-30  update service location                                                      *;
%* 2021-08-16  Remove header documentation                                                  *;
%*                                                                                          *;

%macro lsaf_isjobscheduled(
  lsaf_location=,
  lsaf_path=
  ) /des='Is the job scheduled?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getproductname();

  %global _lsafMsg_         
          _lsafRC_
          _lsafJobIsScheduled_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsg          length=$300;
    attrib scheduled          length=3;
    attrib logMsgPrimary   length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/execution/schedule/ScheduleService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isJobScheduled", "%bquote(&lsaf_location)", "%bquote(&lsaf_path)", results, scheduled);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
	%let lsaf_location = %UPCASE(&lsaf_location.);
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the &lsaf_location job is scheduled: &lsaf_path." ;
      scheduled=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (scheduled) then
      do;
        logMsg=" The &lsaf_location job is scheduled: &lsaf_path." ;
      end;
      else
      do;
        logMsg=" The &lsaf_location job is not scheduled: &lsaf_path." ;
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafJobIsScheduled_= " scheduled;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafJobIsScheduled_", scheduled) ;

  run;

%mend lsaf_isjobscheduled ;
