%* lsaf_isgroupmember                                                                                    *;
%*                                                                                                       *;
%* Indicates whether a user or group is a member of the group in the specified context. A flag can be    *;
%* set to indicate whether the search for membership includes implicit membership.                       *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 1.2                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2013-08-30  updates for standardization and coding conventions                                        *;
%* 2016-08-26  rebrand as LSAF                                                                           *;
%* 2016-01-18  added includeImplicit flag.                                                               *;
%* 2019-01-18  updated for LSAF 5.1 functionality.                                                       *;
%* 2020-12-04  updates for service refactor                                                              *;
%* 2021-08-06  Remove header documentation                                                               *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                       *;
%* 2021-10-20  principal refactor                                                                        *;
%*                                                                                                       *;

%macro lsaf_isgroupmember(
  lsaf_path=,
  lsaf_group=,
  lsaf_member=,
  lsaf_type=,
  lsaf_group_context=,
  lsaf_includeImplicit=
  ) /des='Is the user or group a member of the group in the specified context?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsGroupMember_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %*  Start the datastep to call the java code  *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib isMember        length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/group/GroupService");
	declare javaobj member("com/sas/lsaf/macro/security/SasPrincipalDescriptor", 
                           "%bquote(&lsaf_type)", "%bquote(&lsaf_member)", "%bquote(&lsaf_group_context)");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isMember", "%bquote(&lsaf_path)", "%bquote(&lsaf_group)", member, "%bquote(&lsaf_includeImplicit)", results, isMember);


    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if &lsaf_type &lsaf_member is a member of group &lsaf_group in &lsaf_path.";
      isMember=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isMember) 
        then logMsg=" The &lsaf_type &lsaf_member is a member of group &lsaf_group in &lsaf_path.";
        else logMsg=" The &lsaf_type &lsaf_member is not a member of group &lsaf_group in &lsaf_path.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " option lsaf_includeImplicit = &lsaf_includeImplicit";
    put logMsgPrefix " _lsafIsGroupMember_= " isMember;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsGroupMember_", isMember) ;

  run;

%mend lsaf_isgroupmember;
