%* lsaf_isglobalprivilege                                                                              *;
%*                                                                                                     *;
%* Determines whether the specified value is a valid SAS Life Science Analytics Framework global       *;
%* privilege.                                                                                          *;
%*                                                                                                     *;
%* macrotype LSAF                                                                                      *;
%* since 2.1                                                                                           *;
%* exposure external                                                                                   *;
%*                                                                                                     *;
%* History                                                                                             *;
%* 2019-01-23  initial coding                                                                          *;
%* 2020-07-13  update for refactor of java service hierarchy.                                          *;
%* 2021-08-05  Remove header documentation                                                             *;
%*                                                                                                     *;

%macro lsaf_isglobalprivilege(
  lsaf_privilege=
  ) /des='Is the value a valid global privilege?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsGlobalPrivilege_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode          length=8;
    attrib message             length=$200;
    attrib logMsgPrefix        length=$70;
    attrib logMsg              length=$300;
    attrib isGlobalPrivilege   length=3;
    attrib logMsgPrimary       length=$70;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/privilege/global/GlobalPrivilegeService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isGlobalPrivilege", "%bquote(&lsaf_privilege)", results, isGlobalPrivilege);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the item is a valid global privilege: &lsaf_privilege." ;
      isGlobalPrivilege=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isGlobalPrivilege) 
        then logMsg=" The item is a valid global privilege: &lsaf_privilege.";
        else logMsg=" The item is not a valid global privilege: &lsaf_privilege.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsGlobalPrivilege_= " isGlobalPrivilege;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsGlobalPrivilege_", isGlobalPrivilege);

  run;

%mend lsaf_isglobalprivilege;
