%* lsaf_isfilelocked                                                                                     *;
%*                                                                                                       *;
%* Indicates whether a file that is in the repository is locked.                                         *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 2.3                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2020-01-22  Initial coding                                                                            *;
%* 2021-08-13  Remove header documentation                                                               *;
%*                                                                                                       *;

%macro lsaf_isfilelocked(
  lsaf_path=
  ) /des='Is the file in the repository locked?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsFileLocked_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib isFileLocked    length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isFileLocked", "%bquote(&lsaf_path)", results, isFileLocked);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the file is locked: &lsaf_path.." ;
      isFileLocked=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isFileLocked) then
      do;
        logMsg=" The file is locked: &lsaf_path..";
      end;
      else
      do;
        logMsg=" The file is not locked: &lsaf_path..";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsFileLocked_= " isFileLocked;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsFileLocked_", isFileLocked) ;

  run;

%mend lsaf_isfilelocked;
