%* lsaf_iscontainer                                                                                    *;
%*                                                                                                     *;
%* Indicates whether a repository item is a container. Containers include folders and contexts.        *;
%*                                                                                                     *;
%* macrotype LSAF                                                                                      *;
%* since 1.2                                                                                           *;
%* exposure external                                                                                   *;
%*                                                                                                     *;
%* History                                                                                             *;
%* 2013-08-30  updates for standardization and coding conventions                                      *;
%* 2016-08-26  rebrand as LSAF                                                                         *;
%* 2018-12-10  documentation update for LSAF 5.x behavior                                              *;
%* 2021-08-13  Remove header documentation                                                             *;
%*                                                                                                     *;

%macro lsaf_iscontainer(
  lsaf_path=
  ) /des='Is the item a container?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsContainer_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib isContainer     length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isContainer", "%bquote(&lsaf_path)", results, isContainer);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the item is a container: &lsaf_path." ;
      isContainer=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isContainer) then
      do;
        logMsg=" The item is a container: &lsaf_path.";
      end;
      else
      do;
        logMsg=" The item is not a container: &lsaf_path.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsContainer_= " isContainer;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsContainer_", isContainer);

  run;

%mend lsaf_iscontainer;
