%* lsaf_ischeckedout                                                                                     *;
%*                                                                                                       *;
%* Indicates whether a repository file is checked out.                                                   *;
%*                                                                                                       *;
%* macrotype LSAF                                                                                        *;
%* since 1.5                                                                                             *;
%* exposure external                                                                                     *;
%*                                                                                                       *;
%* History                                                                                               *;
%* 2016-10-04  Initial coding                                                                            *;
%* 2018-01-09  updates to documentation for LSAF 5.1                                                     *;
%* 2019-02-19  update to 2.1                                                                             *;
%* 2021-08-13  Remove header documentation                                                               *;
%*                                                                                                       *;

%macro lsaf_ischeckedout(
  lsaf_path=
  ) /des='Has the file in the repository been checked out?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafIsCheckedOut_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib isCheckedOut    length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticBooleanMethod("isCheckedOut", "%bquote(&lsaf_path)", results, isCheckedOut);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if the file is checked out: &lsaf_path." ;
      isCheckedOut=-1;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      if (isCheckedOut) then
      do;
        logMsg=" The file is checked out: &lsaf_path.";
      end;
      else
      do;
        logMsg=" The file is not checked out: &lsaf_path.";
      end;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafIsCheckedOut_= " isCheckedOut;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafIsCheckedOut_", isCheckedOut) ;

  run;

%mend lsaf_ischeckedout;
