%* lsaf_importstudydetails                                                                       *;
%*                                                                                               *;
%* Imports study details from the specified SAS data set.                                        *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 2.4                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2020-09-25  initial coding                                                                    *;
%* 2021-08-17  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_importstudydetails(
  lsaf_studyId=, 
  lsaf_location=, 
  lsaf_detailspath=,
  lsaf_detailsversion=
  ) /des='Imports study details in the repository.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafRC_
  ;

  %local _lsafRowCount_;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);
  %let _lsafRowCount_=0;

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode           length=8
           message              length=$200
           logMsgPrefix         length=$70
           logMsgPrimary        length=$70
           logMsg               length=$300
    ;

    %*****************************;
    %* Declare the java objects  *;
    %*****************************;
    declare javaobj srv("com/sas/lsaf/macro/clinical/study/StudyService") ;
    declare javaobj importParameters("com/sas/lsaf/macro/clinical/SasClinicalUpdateParameters");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");
 
    %***********************************;
    %* Attempt the operation           *;
    %***********************************;

    importParameters.callVoidMethod("updateImportData", "%bquote(&lsaf_location)", "%bquote(&lsaf_detailspath)", "%bquote(&lsaf_detailsversion)", 
          "");

    srv.callStaticVoidMethod("importStudyDetails", "%bquote(&lsaf_studyid)", importParameters, results);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Could not import the study details metadata." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Successful import of the study details.";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    if (returnCode ne 0) 
      then put logMsgPrefix " The study details were not imported.";
      else put logMsgPrefix " The study details were imported.";
    put logMsgPrefix " _lsafMsg_= " message ;
    put logMsgPrefix " _lsafRC_= " returnCode ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
  run;
%mend lsaf_importstudydetails;
