%* lsaf_hasscopedprivilege                                                                         *;
%*                                                                                                 *;
%* Indicates whether a user or group has a specific role privilege in the specified context.       *;
%*                                                                                                 *;
%* macrotype LSAF                                                                                  *;
%* since 1.5                                                                                       *;
%* exposure external                                                                               *;
%*                                                                                                 *;
%* History                                                                                         *;
%* 2016-08-19  original code                                                                       *;
%* 2019-01-29  updated and rebranded to 2.1                                                        *; 
%* 2019-02-14  renamed from lsaf_hascontextprivilege                                               *;
%* 2020-12-07  updates for service refactor                                                        *;
%* 2021-08-13  Remove header documentation                                                         *;
%* 2021-09-20  Remove parameter defaults (DE16775)                                                 *;
%* 2021-10-21  principal refactor                                                                  *;
%*                                                                                                 *;

%macro lsaf_hasscopedprivilege(
  lsaf_path=,
  lsaf_privilege=,
  lsaf_member=,
  lsaf_type=,
  lsaf_group_context=
  ) /des='Does the user or group have the privilege in the specified context?';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafHasScopedPrivilege_
          _lsafMsg_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib hasPriv         length=3;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/security/role/RoleService");
	declare javaobj member("com/sas/lsaf/macro/security/SasPrincipalDescriptor", 
                           "%bquote(&lsaf_type)", "%bquote(&lsaf_member)", "%bquote(&lsaf_group_context)");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;

    srv.callStaticBooleanMethod("hasPrivilegeAtContext", "%bquote(&lsaf_path)", "%bquote(&lsaf_privilege)", member, results, hasPriv);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine if &lsaf_type &lsaf_member has the privilege &lsaf_privilege in &lsaf_path..";
      hasPriv=-1;
    end;
      else
    do;
      logMsgPrimary=logMsgPrefix;
      if (hasPriv) 
        then logMsg=" The &lsaf_type &lsaf_member has the privilege &lsaf_privilege in &lsaf_path.." ;
        else logMsg=" The &lsaf_type &lsaf_member does not have the privilege &lsaf_privilege in &lsaf_path.." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafHasScopedPrivilege_= " hasPriv;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafHasScopedPrivilege_", hasPriv) ;

  run;

%mend lsaf_hasscopedprivilege;
