%* lsaf_hasglobalprivilege                                                                    *;                                                         
%*                                                                                            *;                                                   
%* Determines whether a global privilege is assigned to a user account. A list of privilege   *;
%* IDs can be found by running the %lsaf_getglobalprivileges and checking the PrivilegeID     *;
%* column.                                                                                    *;                                                   
%*                                                                                            *;                                                   
%* macrotype LSAF                                                                             *;                                                  
%* since 1.3                                                                                  *;                                                   
%* exposure external                                                                          *;                                                   
%*                                                                                            *;                                                   
%* History                                                                                    *;                                                   
%* 2013-11-01  initial coding                                                                 *;                                                   
%* 2016-08-26  rebrand as LSAF                                                                *;
%* 2019-01-18  renamed from lsaf_isuserprivilege to lsaf_hasglobalprivilege                   *;
%* 2020-07-13  update for refactor of java service hierarchy.                                 *; 
%* 2021-08-05  Remove header documentation                                                    *;
%*                                                                                            *;
                                                                                                                         
%macro lsaf_hasglobalprivilege(                                                                                                                          
  lsaf_userid=,                                                                                                                                       
  lsaf_privilege=                                                                                                                                     
  ) /des='Is the global privilege assigned to the specified user?';                                                                                   
                                                                                                                                                      
  %****************************************;                                                                                                          
  %* Initialize macro variables           *;                                                                                                          
  %****************************************;                                                                                                          
  %lsaf_getProductName();

  %global _lsafHasGlobalPrivilege_                                                                                                                       
          _lsafMsg_                                                                                                                                   
          _lsafRC_                                                                                                                                    
  ;                                                                                                                                                   
                                                                                                                                                      
  %let _lsafRC_ =%str(-999);                                                                                                                          
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);                                                                 
                                                                                                                                                      
  %**********************************************;                                                                                                    
  %* Start the datastep to call the java code   *;                                                                                                    
  %**********************************************;                                                                                                    
  data _null_;                                                                                                                                        
    attrib returnCode       length=8;                                                                                                                  
    attrib message          length=$200;                                                                                                               
    attrib logMsgPrefix     length=$70;                                                                                                                
    attrib logMsgPrimary    length=$70;                                                                                                                
    attrib logMsg           length=$300;                                                                                                               
    attrib hasPrivilege     length=3;                                                                                                                  
                                                                                                                                                      
    %***********************************;                                                                                                             
    %* Declare the java objects        *;                                                                                                             
    %***********************************;                                                                                                             
    declare javaobj srv("com/sas/lsaf/macro/security/privilege/global/GlobalPrivilegeService");                                                                              
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");                                                                                      
                                                                                                                                                      
    %***********************************;                                                                                                             
    %* Attempt the operation           *;                                                                                                             
    %***********************************;                                                                                                             
    srv.callStaticBooleanMethod("hasPrivilege", "%bquote(&lsaf_userid)", "%bquote(&lsaf_privilege)", results, hasPrivilege);                          
                                                                                                                                                      
    %***********************************;                                                                                                             
    %* Retrieve the results            *;                                                                                                             
    %***********************************;                                                                                                             
    results.callIntMethod("getReturnCode", returnCode);                                                                                               
    results.callStringMethod("getReturnMessage", message);                                                                                            
                                                                                                                                                      
    %***********************************;                                                                                                             
    %* Process the results             *;                                                                                                             
    %***********************************;                                                                                                             
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";                                                                                            
    if (returnCode ne 0) then                                                                                                                         
    do;                                                                                                                                               
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";                                                                                        
      logMsg=" Cannot determine if &lsaf_privilege is assigned to the user &lsaf_userid..";                                                           
      hasPrivilege=-1;                                                                                                                                
    end;                                                                                                                                              
    else                                                                                                                                            
    do;                                                                                                                                               
      logMsgPrimary=logMsgPrefix;                                                                                            
      if (hasPrivilege) 
        then logMsg=" &lsaf_privilege is assigned to the user &lsaf_userid.." ;                                                                            
        else logMsg=" &lsaf_privilege is not assigned to the user &lsaf_userid.." ;                                                                        
    end;                                                                                                                                              
                                                                                                                                                      
    %***********************************;                                                                                                             
    %* Print messages in log           *;                                                                                                             
    %***********************************;                                                                                                             
    put;                                                                                                                                              
    put logMsgPrimary " " logMsg;                                                                                                                      
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));                                                                                          
    put logMsgPrefix " _lsafMsg_= " message;                                                                                                          
    put logMsgPrefix " _lsafRC_= " returnCode;                                                                                                        
    put logMsgPrefix " _lsafHasGlobalPrivilege_= " hasPrivilege;                                                                                         
    put;                                                                                                                                              
                                                                                                                                                      
    %***********************************;                                                                                                             
    %* Set the macro variables         *;                                                                                                             
    %***********************************;                                                                                                             
    call symputx("_lsafRC_", returnCode);                                                                                                             
    call symputx("_lsafMsg_", message);                                                                                                               
    call symputx("_lsafHasGlobalPrivilege_", hasPrivilege);                                                                                              
                                                                                                                                                      
  run;                                                                                                                                                
                                                                                                                                                      
%mend lsaf_hasglobalprivilege;                                                                                                                          
