%* lsaf_getworkspacecheckoutstatus                                           *;
%*                                                                           *;
%* Gets checked out status of the workspace file.                            *;
%*                                                                           *;
%* macrotype LSAF                                                            *;
%* since 2.6                                                                 *;
%* exposure external                                                         *;
%*                                                                           *;
%* History                                                                   *;
%* 2021-11-10  initial code                                                  *;
%*                                                                           *;

%macro lsaf_getworkspacecheckoutstatus(
  lsaf_path=
  ) /des='Returns the checkout status of a SAS Life Science Analytics Framework workspace file or folder.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafWorkspaceCheckoutStatus_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib status          length=$25;

    status="";

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/workspace/WorkspaceService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getCheckoutStatus", "%bquote(&lsaf_path)", results, status);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Cannot determine workspace checkout status: &lsaf_path." ;
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" Returned workspace checkout status: &lsaf_path." ;
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary " " logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix " _lsafMsg_= " message;
    put logMsgPrefix " _lsafRC_= " returnCode;
    put logMsgPrefix " _lsafWorkspaceCheckoutStatus_= " status;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafMsg_", message);
    call symputx("_lsafWorkspaceCheckoutStatus_", strip(status) ) ;

  run;

%mend lsaf_getworkspacecheckoutstatus;
