%* lsaf_gettype                                                                                  *;
%*                                                                                               *;
%* Gets the item type for the item at the specified repository path.                             *;
%*                                                                                               *;
%* macrotype LSAF                                                                                *;
%* since 1.4                                                                                     *;
%* exposure external                                                                             *;
%*                                                                                               *;
%* History                                                                                       *;
%* 2014-03-07  initial coding                                                                    *;
%* 2016-08-26  rebrand as LSAF                                                                   *;
%* 2018-12-10  documentation update for LSAF 5.x behavior                                        *;
%* 2019-01-08  renamed from lsaf_getobjecttype to lsaf_gettype                                   *;
%* 2021-08-13  Remove header documentation                                                       *;
%*                                                                                               *;

%macro lsaf_gettype(
  lsaf_path=
  ) /des='Get the SAS Life Science Analytics Framework item type for the specified path.';

  %****************************************;
  %* Initialize macro variables           *;
  %****************************************;
  %lsaf_getProductName();

  %global _lsafMsg_
          _lsafType_
          _lsafRC_
  ;

  %let _lsafRC_ =%str(-999);
  %let _lsafMsg_=%str(The SAS Macro did not execute properly.  Unknown err%str(or).);

  %**********************************************;
  %* Start the datastep to call the java code   *;
  %**********************************************;
  data _null_;
    attrib returnCode      length=8;
    attrib message         length=$200;
    attrib logMsgPrefix    length=$70;
    attrib logMsgPrimary   length=$70;
    attrib logMsg          length=$300;
    attrib type            length=$30;

    %***********************************;
    %* Declare the java objects        *;
    %***********************************;
    declare javaobj srv("com/sas/lsaf/macro/content/repository/RepositoryService");
    declare javaobj results("com/sas/lsaf/macro/common/result/Result");

    %***********************************;
    %* Attempt the operation           *;
    %***********************************;
    srv.callStaticStringMethod("getItemType", "%bquote(&lsaf_path)", results, type);

    %***********************************;
    %* Retrieve the results            *;
    %***********************************;
    results.callIntMethod("getReturnCode", returnCode);
    results.callStringMethod("getReturnMessage", message);

    %***********************************;
    %* Process the results             *;
    %***********************************;
    logMsgPrefix="NOTE: &_LSAF_PRODUCT_NAME_ Macro: * ";
    if (returnCode ne 0) then
    do;
      logMsgPrimary="ERR%str(OR): &_LSAF_PRODUCT_NAME_ Macro:";
      logMsg=" Could not determine the item type: &lsaf_path." ;
      type="";
    end;
    else
    do;
      logMsgPrimary=logMsgPrefix;
      logMsg=" The item type was returned for path: &lsaf_path";
    end;

    %***********************************;
    %* Print messages in log           *;
    %***********************************;
    put;
    put logMsgPrimary logMsg;
    put logMsgPrefix " " %sysfunc(lowcase("&SYSMACRONAME"));
    put logMsgPrefix "_lsafMsg_=" message ;
    put logMsgPrefix "_lsafRC_=" returnCode ;
    put logMsgPrefix "_lsafType_=" type ;
    put;

    %***********************************;
    %* Set the macro variables         *;
    %***********************************;
    call symputx("_lsafRC_", returnCode);
    call symputx("_lsafType_", type) ;
    call symputx("_lsafMsg_", message);

  run;

%mend lsaf_gettype ;
